/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteObjectsOnCancelRequest extends LakeFormationRequest implements
        ToCopyableBuilder<DeleteObjectsOnCancelRequest.Builder, DeleteObjectsOnCancelRequest> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CatalogId").getter(getter(DeleteObjectsOnCancelRequest::catalogId)).setter(setter(Builder::catalogId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(DeleteObjectsOnCancelRequest::databaseName))
            .setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableName").getter(getter(DeleteObjectsOnCancelRequest::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<String> TRANSACTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TransactionId").getter(getter(DeleteObjectsOnCancelRequest::transactionId))
            .setter(setter(Builder::transactionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransactionId").build()).build();

    private static final SdkField<List<VirtualObject>> OBJECTS_FIELD = SdkField
            .<List<VirtualObject>> builder(MarshallingType.LIST)
            .memberName("Objects")
            .getter(getter(DeleteObjectsOnCancelRequest::objects))
            .setter(setter(Builder::objects))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Objects").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VirtualObject> builder(MarshallingType.SDK_POJO)
                                            .constructor(VirtualObject::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD,
            DATABASE_NAME_FIELD, TABLE_NAME_FIELD, TRANSACTION_ID_FIELD, OBJECTS_FIELD));

    private final String catalogId;

    private final String databaseName;

    private final String tableName;

    private final String transactionId;

    private final List<VirtualObject> objects;

    private DeleteObjectsOnCancelRequest(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
        this.transactionId = builder.transactionId;
        this.objects = builder.objects;
    }

    /**
     * <p>
     * The Glue data catalog that contains the governed table. Defaults to the current account ID.
     * </p>
     * 
     * @return The Glue data catalog that contains the governed table. Defaults to the current account ID.
     */
    public final String catalogId() {
        return catalogId;
    }

    /**
     * <p>
     * The database that contains the governed table.
     * </p>
     * 
     * @return The database that contains the governed table.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * The name of the governed table.
     * </p>
     * 
     * @return The name of the governed table.
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * <p>
     * ID of the transaction that the writes occur in.
     * </p>
     * 
     * @return ID of the transaction that the writes occur in.
     */
    public final String transactionId() {
        return transactionId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Objects property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasObjects() {
        return objects != null && !(objects instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of VirtualObject structures, which indicates the Amazon S3 objects to be deleted if the transaction
     * cancels.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasObjects} method.
     * </p>
     * 
     * @return A list of VirtualObject structures, which indicates the Amazon S3 objects to be deleted if the
     *         transaction cancels.
     */
    public final List<VirtualObject> objects() {
        return objects;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(transactionId());
        hashCode = 31 * hashCode + Objects.hashCode(hasObjects() ? objects() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteObjectsOnCancelRequest)) {
            return false;
        }
        DeleteObjectsOnCancelRequest other = (DeleteObjectsOnCancelRequest) obj;
        return Objects.equals(catalogId(), other.catalogId()) && Objects.equals(databaseName(), other.databaseName())
                && Objects.equals(tableName(), other.tableName()) && Objects.equals(transactionId(), other.transactionId())
                && hasObjects() == other.hasObjects() && Objects.equals(objects(), other.objects());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteObjectsOnCancelRequest").add("CatalogId", catalogId()).add("DatabaseName", databaseName())
                .add("TableName", tableName()).add("TransactionId", transactionId())
                .add("Objects", hasObjects() ? objects() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CatalogId":
            return Optional.ofNullable(clazz.cast(catalogId()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "TransactionId":
            return Optional.ofNullable(clazz.cast(transactionId()));
        case "Objects":
            return Optional.ofNullable(clazz.cast(objects()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteObjectsOnCancelRequest, T> g) {
        return obj -> g.apply((DeleteObjectsOnCancelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LakeFormationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteObjectsOnCancelRequest> {
        /**
         * <p>
         * The Glue data catalog that contains the governed table. Defaults to the current account ID.
         * </p>
         * 
         * @param catalogId
         *        The Glue data catalog that contains the governed table. Defaults to the current account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalogId(String catalogId);

        /**
         * <p>
         * The database that contains the governed table.
         * </p>
         * 
         * @param databaseName
         *        The database that contains the governed table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * The name of the governed table.
         * </p>
         * 
         * @param tableName
         *        The name of the governed table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * ID of the transaction that the writes occur in.
         * </p>
         * 
         * @param transactionId
         *        ID of the transaction that the writes occur in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transactionId(String transactionId);

        /**
         * <p>
         * A list of VirtualObject structures, which indicates the Amazon S3 objects to be deleted if the transaction
         * cancels.
         * </p>
         * 
         * @param objects
         *        A list of VirtualObject structures, which indicates the Amazon S3 objects to be deleted if the
         *        transaction cancels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objects(Collection<VirtualObject> objects);

        /**
         * <p>
         * A list of VirtualObject structures, which indicates the Amazon S3 objects to be deleted if the transaction
         * cancels.
         * </p>
         * 
         * @param objects
         *        A list of VirtualObject structures, which indicates the Amazon S3 objects to be deleted if the
         *        transaction cancels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objects(VirtualObject... objects);

        /**
         * <p>
         * A list of VirtualObject structures, which indicates the Amazon S3 objects to be deleted if the transaction
         * cancels.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lakeformation.model.VirtualObject.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.lakeformation.model.VirtualObject#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lakeformation.model.VirtualObject.Builder#build()} is called
         * immediately and its result is passed to {@link #objects(List<VirtualObject>)}.
         * 
         * @param objects
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lakeformation.model.VirtualObject.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #objects(java.util.Collection<VirtualObject>)
         */
        Builder objects(Consumer<VirtualObject.Builder>... objects);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LakeFormationRequest.BuilderImpl implements Builder {
        private String catalogId;

        private String databaseName;

        private String tableName;

        private String transactionId;

        private List<VirtualObject> objects = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteObjectsOnCancelRequest model) {
            super(model);
            catalogId(model.catalogId);
            databaseName(model.databaseName);
            tableName(model.tableName);
            transactionId(model.transactionId);
            objects(model.objects);
        }

        public final String getCatalogId() {
            return catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getTableName() {
            return tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final String getTransactionId() {
            return transactionId;
        }

        public final void setTransactionId(String transactionId) {
            this.transactionId = transactionId;
        }

        @Override
        public final Builder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public final List<VirtualObject.Builder> getObjects() {
            List<VirtualObject.Builder> result = VirtualObjectListCopier.copyToBuilder(this.objects);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setObjects(Collection<VirtualObject.BuilderImpl> objects) {
            this.objects = VirtualObjectListCopier.copyFromBuilder(objects);
        }

        @Override
        public final Builder objects(Collection<VirtualObject> objects) {
            this.objects = VirtualObjectListCopier.copy(objects);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objects(VirtualObject... objects) {
            objects(Arrays.asList(objects));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objects(Consumer<VirtualObject.Builder>... objects) {
            objects(Stream.of(objects).map(c -> VirtualObject.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteObjectsOnCancelRequest build() {
            return new DeleteObjectsOnCancelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
