/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTableStorageOptimizersResponse extends LakeFormationResponse implements
        ToCopyableBuilder<ListTableStorageOptimizersResponse.Builder, ListTableStorageOptimizersResponse> {
    private static final SdkField<List<StorageOptimizer>> STORAGE_OPTIMIZER_LIST_FIELD = SdkField
            .<List<StorageOptimizer>> builder(MarshallingType.LIST)
            .memberName("StorageOptimizerList")
            .getter(getter(ListTableStorageOptimizersResponse::storageOptimizerList))
            .setter(setter(Builder::storageOptimizerList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageOptimizerList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StorageOptimizer> builder(MarshallingType.SDK_POJO)
                                            .constructor(StorageOptimizer::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListTableStorageOptimizersResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_OPTIMIZER_LIST_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<StorageOptimizer> storageOptimizerList;

    private final String nextToken;

    private ListTableStorageOptimizersResponse(BuilderImpl builder) {
        super(builder);
        this.storageOptimizerList = builder.storageOptimizerList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the StorageOptimizerList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStorageOptimizerList() {
        return storageOptimizerList != null && !(storageOptimizerList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the storage optimizers associated with a table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStorageOptimizerList} method.
     * </p>
     * 
     * @return A list of the storage optimizers associated with a table.
     */
    public final List<StorageOptimizer> storageOptimizerList() {
        return storageOptimizerList;
    }

    /**
     * <p>
     * A continuation token for paginating the returned list of tokens, returned if the current segment of the list is
     * not the last.
     * </p>
     * 
     * @return A continuation token for paginating the returned list of tokens, returned if the current segment of the
     *         list is not the last.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasStorageOptimizerList() ? storageOptimizerList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTableStorageOptimizersResponse)) {
            return false;
        }
        ListTableStorageOptimizersResponse other = (ListTableStorageOptimizersResponse) obj;
        return hasStorageOptimizerList() == other.hasStorageOptimizerList()
                && Objects.equals(storageOptimizerList(), other.storageOptimizerList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTableStorageOptimizersResponse")
                .add("StorageOptimizerList", hasStorageOptimizerList() ? storageOptimizerList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StorageOptimizerList":
            return Optional.ofNullable(clazz.cast(storageOptimizerList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTableStorageOptimizersResponse, T> g) {
        return obj -> g.apply((ListTableStorageOptimizersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LakeFormationResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListTableStorageOptimizersResponse> {
        /**
         * <p>
         * A list of the storage optimizers associated with a table.
         * </p>
         * 
         * @param storageOptimizerList
         *        A list of the storage optimizers associated with a table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageOptimizerList(Collection<StorageOptimizer> storageOptimizerList);

        /**
         * <p>
         * A list of the storage optimizers associated with a table.
         * </p>
         * 
         * @param storageOptimizerList
         *        A list of the storage optimizers associated with a table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageOptimizerList(StorageOptimizer... storageOptimizerList);

        /**
         * <p>
         * A list of the storage optimizers associated with a table.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lakeformation.model.StorageOptimizer.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.lakeformation.model.StorageOptimizer#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lakeformation.model.StorageOptimizer.Builder#build()} is called
         * immediately and its result is passed to {@link #storageOptimizerList(List<StorageOptimizer>)}.
         * 
         * @param storageOptimizerList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lakeformation.model.StorageOptimizer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storageOptimizerList(java.util.Collection<StorageOptimizer>)
         */
        Builder storageOptimizerList(Consumer<StorageOptimizer.Builder>... storageOptimizerList);

        /**
         * <p>
         * A continuation token for paginating the returned list of tokens, returned if the current segment of the list
         * is not the last.
         * </p>
         * 
         * @param nextToken
         *        A continuation token for paginating the returned list of tokens, returned if the current segment of
         *        the list is not the last.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends LakeFormationResponse.BuilderImpl implements Builder {
        private List<StorageOptimizer> storageOptimizerList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTableStorageOptimizersResponse model) {
            super(model);
            storageOptimizerList(model.storageOptimizerList);
            nextToken(model.nextToken);
        }

        public final List<StorageOptimizer.Builder> getStorageOptimizerList() {
            List<StorageOptimizer.Builder> result = StorageOptimizerListCopier.copyToBuilder(this.storageOptimizerList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStorageOptimizerList(Collection<StorageOptimizer.BuilderImpl> storageOptimizerList) {
            this.storageOptimizerList = StorageOptimizerListCopier.copyFromBuilder(storageOptimizerList);
        }

        @Override
        public final Builder storageOptimizerList(Collection<StorageOptimizer> storageOptimizerList) {
            this.storageOptimizerList = StorageOptimizerListCopier.copy(storageOptimizerList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageOptimizerList(StorageOptimizer... storageOptimizerList) {
            storageOptimizerList(Arrays.asList(storageOptimizerList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageOptimizerList(Consumer<StorageOptimizer.Builder>... storageOptimizerList) {
            storageOptimizerList(Stream.of(storageOptimizerList).map(c -> StorageOptimizer.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTableStorageOptimizersResponse build() {
            return new ListTableStorageOptimizersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
