/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lakeformation.LakeFormationAsyncClient;
import software.amazon.awssdk.services.lakeformation.model.GetEffectivePermissionsForPathRequest;
import software.amazon.awssdk.services.lakeformation.model.GetEffectivePermissionsForPathResponse;

public class GetEffectivePermissionsForPathPublisher
implements SdkPublisher<GetEffectivePermissionsForPathResponse> {
    private final LakeFormationAsyncClient client;
    private final GetEffectivePermissionsForPathRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetEffectivePermissionsForPathPublisher(LakeFormationAsyncClient client, GetEffectivePermissionsForPathRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetEffectivePermissionsForPathPublisher(LakeFormationAsyncClient client, GetEffectivePermissionsForPathRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetEffectivePermissionsForPathResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetEffectivePermissionsForPathResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetEffectivePermissionsForPathResponseFetcher
    implements AsyncPageFetcher<GetEffectivePermissionsForPathResponse> {
        private GetEffectivePermissionsForPathResponseFetcher() {
        }

        public boolean hasNextPage(GetEffectivePermissionsForPathResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetEffectivePermissionsForPathResponse> nextPage(GetEffectivePermissionsForPathResponse previousPage) {
            if (previousPage == null) {
                return GetEffectivePermissionsForPathPublisher.this.client.getEffectivePermissionsForPath(GetEffectivePermissionsForPathPublisher.this.firstRequest);
            }
            return GetEffectivePermissionsForPathPublisher.this.client.getEffectivePermissionsForPath((GetEffectivePermissionsForPathRequest)((Object)GetEffectivePermissionsForPathPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

