/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideoarchivedmedia.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.KinesisVideoArchivedMediaClient;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.internal.UserAgentUtils;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.Fragment;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ListFragmentsRequest;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ListFragmentsResponse;

public class ListFragmentsIterable
implements SdkIterable<ListFragmentsResponse> {
    private final KinesisVideoArchivedMediaClient client;
    private final ListFragmentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFragmentsIterable(KinesisVideoArchivedMediaClient client, ListFragmentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListFragmentsResponseFetcher();
    }

    public Iterator<ListFragmentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Fragment> fragments() {
        Function<ListFragmentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.fragments() != null) {
                return response.fragments().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListFragmentsResponseFetcher
    implements SyncPageFetcher<ListFragmentsResponse> {
        private ListFragmentsResponseFetcher() {
        }

        public boolean hasNextPage(ListFragmentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListFragmentsResponse nextPage(ListFragmentsResponse previousPage) {
            if (previousPage == null) {
                return ListFragmentsIterable.this.client.listFragments(ListFragmentsIterable.this.firstRequest);
            }
            return ListFragmentsIterable.this.client.listFragments((ListFragmentsRequest)((Object)ListFragmentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

