/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.KinesisAnalyticsV2Response;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.OutputDescription;
import software.amazon.awssdk.services.kinesisanalyticsv2.model.OutputDescriptionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddApplicationOutputResponse
extends KinesisAnalyticsV2Response
implements ToCopyableBuilder<Builder, AddApplicationOutputResponse> {
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationARN").getter(AddApplicationOutputResponse.getter(AddApplicationOutputResponse::applicationARN)).setter(AddApplicationOutputResponse.setter(Builder::applicationARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationARN").build()}).build();
    private static final SdkField<Long> APPLICATION_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ApplicationVersionId").getter(AddApplicationOutputResponse.getter(AddApplicationOutputResponse::applicationVersionId)).setter(AddApplicationOutputResponse.setter(Builder::applicationVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationVersionId").build()}).build();
    private static final SdkField<List<OutputDescription>> OUTPUT_DESCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OutputDescriptions").getter(AddApplicationOutputResponse.getter(AddApplicationOutputResponse::outputDescriptions)).setter(AddApplicationOutputResponse.setter(Builder::outputDescriptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputDescriptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OutputDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ARN_FIELD, APPLICATION_VERSION_ID_FIELD, OUTPUT_DESCRIPTIONS_FIELD));
    private final String applicationARN;
    private final Long applicationVersionId;
    private final List<OutputDescription> outputDescriptions;

    private AddApplicationOutputResponse(BuilderImpl builder) {
        super(builder);
        this.applicationARN = builder.applicationARN;
        this.applicationVersionId = builder.applicationVersionId;
        this.outputDescriptions = builder.outputDescriptions;
    }

    public final String applicationARN() {
        return this.applicationARN;
    }

    public final Long applicationVersionId() {
        return this.applicationVersionId;
    }

    public final boolean hasOutputDescriptions() {
        return this.outputDescriptions != null && !(this.outputDescriptions instanceof SdkAutoConstructList);
    }

    public final List<OutputDescription> outputDescriptions() {
        return this.outputDescriptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputDescriptions() ? this.outputDescriptions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddApplicationOutputResponse)) {
            return false;
        }
        AddApplicationOutputResponse other = (AddApplicationOutputResponse)((Object)obj);
        return Objects.equals(this.applicationARN(), other.applicationARN()) && Objects.equals(this.applicationVersionId(), other.applicationVersionId()) && this.hasOutputDescriptions() == other.hasOutputDescriptions() && Objects.equals(this.outputDescriptions(), other.outputDescriptions());
    }

    public final String toString() {
        return ToString.builder((String)"AddApplicationOutputResponse").add("ApplicationARN", (Object)this.applicationARN()).add("ApplicationVersionId", (Object)this.applicationVersionId()).add("OutputDescriptions", this.hasOutputDescriptions() ? this.outputDescriptions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationARN": {
                return Optional.ofNullable(clazz.cast(this.applicationARN()));
            }
            case "ApplicationVersionId": {
                return Optional.ofNullable(clazz.cast(this.applicationVersionId()));
            }
            case "OutputDescriptions": {
                return Optional.ofNullable(clazz.cast(this.outputDescriptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddApplicationOutputResponse, T> g) {
        return obj -> g.apply((AddApplicationOutputResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisAnalyticsV2Response.BuilderImpl
    implements Builder {
        private String applicationARN;
        private Long applicationVersionId;
        private List<OutputDescription> outputDescriptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AddApplicationOutputResponse model) {
            super(model);
            this.applicationARN(model.applicationARN);
            this.applicationVersionId(model.applicationVersionId);
            this.outputDescriptions(model.outputDescriptions);
        }

        public final String getApplicationARN() {
            return this.applicationARN;
        }

        public final void setApplicationARN(String applicationARN) {
            this.applicationARN = applicationARN;
        }

        @Override
        public final Builder applicationARN(String applicationARN) {
            this.applicationARN = applicationARN;
            return this;
        }

        public final Long getApplicationVersionId() {
            return this.applicationVersionId;
        }

        public final void setApplicationVersionId(Long applicationVersionId) {
            this.applicationVersionId = applicationVersionId;
        }

        @Override
        public final Builder applicationVersionId(Long applicationVersionId) {
            this.applicationVersionId = applicationVersionId;
            return this;
        }

        public final List<OutputDescription.Builder> getOutputDescriptions() {
            List<OutputDescription.Builder> result = OutputDescriptionsCopier.copyToBuilder(this.outputDescriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputDescriptions(Collection<OutputDescription.BuilderImpl> outputDescriptions) {
            this.outputDescriptions = OutputDescriptionsCopier.copyFromBuilder(outputDescriptions);
        }

        @Override
        public final Builder outputDescriptions(Collection<OutputDescription> outputDescriptions) {
            this.outputDescriptions = OutputDescriptionsCopier.copy(outputDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputDescriptions(OutputDescription ... outputDescriptions) {
            this.outputDescriptions(Arrays.asList(outputDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputDescriptions(Consumer<OutputDescription.Builder> ... outputDescriptions) {
            this.outputDescriptions(Stream.of(outputDescriptions).map(c -> (OutputDescription)((OutputDescription.Builder)OutputDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public AddApplicationOutputResponse build() {
            return new AddApplicationOutputResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KinesisAnalyticsV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AddApplicationOutputResponse> {
        public Builder applicationARN(String var1);

        public Builder applicationVersionId(Long var1);

        public Builder outputDescriptions(Collection<OutputDescription> var1);

        public Builder outputDescriptions(OutputDescription ... var1);

        public Builder outputDescriptions(Consumer<OutputDescription.Builder> ... var1);
    }
}

