/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisanalyticsv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ConfigurationType {
    DEFAULT("DEFAULT"),
    CUSTOM("CUSTOM"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ConfigurationType> VALUE_MAP;
    private final String value;

    private ConfigurationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ConfigurationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ConfigurationType> knownValues() {
        EnumSet<ConfigurationType> knownValues = EnumSet.allOf(ConfigurationType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ConfigurationType.class, ConfigurationType::toString);
    }
}

