/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesis.model;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;

@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultSubscribeToShardVisitorBuilder implements SubscribeToShardResponseHandler.Visitor.Builder {
    private Consumer<SubscribeToShardEventStream> onDefault;

    private Consumer<SubscribeToShardEvent> onSubscribeToShardEvent;

    @Override
    public SubscribeToShardResponseHandler.Visitor.Builder onDefault(Consumer<SubscribeToShardEventStream> c) {
        this.onDefault = c;
        return this;
    }

    @Override
    public SubscribeToShardResponseHandler.Visitor build() {
        return new VisitorFromBuilder(this);
    }

    @Override
    public SubscribeToShardResponseHandler.Visitor.Builder onSubscribeToShardEvent(Consumer<SubscribeToShardEvent> c) {
        this.onSubscribeToShardEvent = c;
        return this;
    }

    @Generated("software.amazon.awssdk:codegen")
    class VisitorFromBuilder implements SubscribeToShardResponseHandler.Visitor {
        private final Consumer<SubscribeToShardEventStream> onDefault;

        private final Consumer<SubscribeToShardEvent> onSubscribeToShardEvent;

        VisitorFromBuilder(DefaultSubscribeToShardVisitorBuilder builder) {
            this.onDefault = builder.onDefault != null ? builder.onDefault
                    : SubscribeToShardResponseHandler.Visitor.super::visitDefault;
            this.onSubscribeToShardEvent = builder.onSubscribeToShardEvent != null ? builder.onSubscribeToShardEvent
                    : SubscribeToShardResponseHandler.Visitor.super::visit;
        }

        @Override
        public void visitDefault(SubscribeToShardEventStream event) {
            onDefault.accept(event);
        }

        @Override
        public void visit(SubscribeToShardEvent event) {
            onSubscribeToShardEvent.accept(event);
        }
    }
}
