/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesis.model.KinesisRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListShardsRequest
extends KinesisRequest
implements ToCopyableBuilder<Builder, ListShardsRequest> {
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListShardsRequest.getter(ListShardsRequest::streamName)).setter(ListShardsRequest.setter(Builder::streamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListShardsRequest.getter(ListShardsRequest::nextToken)).setter(ListShardsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<String> EXCLUSIVE_START_SHARD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListShardsRequest.getter(ListShardsRequest::exclusiveStartShardId)).setter(ListShardsRequest.setter(Builder::exclusiveStartShardId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusiveStartShardId").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ListShardsRequest.getter(ListShardsRequest::maxResults)).setter(ListShardsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<Instant> STREAM_CREATION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ListShardsRequest.getter(ListShardsRequest::streamCreationTimestamp)).setter(ListShardsRequest.setter(Builder::streamCreationTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamCreationTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAME_FIELD, NEXT_TOKEN_FIELD, EXCLUSIVE_START_SHARD_ID_FIELD, MAX_RESULTS_FIELD, STREAM_CREATION_TIMESTAMP_FIELD));
    private final String streamName;
    private final String nextToken;
    private final String exclusiveStartShardId;
    private final Integer maxResults;
    private final Instant streamCreationTimestamp;

    private ListShardsRequest(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.nextToken = builder.nextToken;
        this.exclusiveStartShardId = builder.exclusiveStartShardId;
        this.maxResults = builder.maxResults;
        this.streamCreationTimestamp = builder.streamCreationTimestamp;
    }

    public String streamName() {
        return this.streamName;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public String exclusiveStartShardId() {
        return this.exclusiveStartShardId;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public Instant streamCreationTimestamp() {
        return this.streamCreationTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.exclusiveStartShardId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamCreationTimestamp());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListShardsRequest)) {
            return false;
        }
        ListShardsRequest other = (ListShardsRequest)((Object)obj);
        return Objects.equals(this.streamName(), other.streamName()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.exclusiveStartShardId(), other.exclusiveStartShardId()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.streamCreationTimestamp(), other.streamCreationTimestamp());
    }

    public String toString() {
        return ToString.builder((String)"ListShardsRequest").add("StreamName", (Object)this.streamName()).add("NextToken", (Object)this.nextToken()).add("ExclusiveStartShardId", (Object)this.exclusiveStartShardId()).add("MaxResults", (Object)this.maxResults()).add("StreamCreationTimestamp", (Object)this.streamCreationTimestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamName": {
                return Optional.ofNullable(clazz.cast(this.streamName()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ExclusiveStartShardId": {
                return Optional.ofNullable(clazz.cast(this.exclusiveStartShardId()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "StreamCreationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.streamCreationTimestamp()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListShardsRequest, T> g) {
        return obj -> g.apply((ListShardsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisRequest.BuilderImpl
    implements Builder {
        private String streamName;
        private String nextToken;
        private String exclusiveStartShardId;
        private Integer maxResults;
        private Instant streamCreationTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(ListShardsRequest model) {
            super(model);
            this.streamName(model.streamName);
            this.nextToken(model.nextToken);
            this.exclusiveStartShardId(model.exclusiveStartShardId);
            this.maxResults(model.maxResults);
            this.streamCreationTimestamp(model.streamCreationTimestamp);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getExclusiveStartShardId() {
            return this.exclusiveStartShardId;
        }

        @Override
        public final Builder exclusiveStartShardId(String exclusiveStartShardId) {
            this.exclusiveStartShardId = exclusiveStartShardId;
            return this;
        }

        public final void setExclusiveStartShardId(String exclusiveStartShardId) {
            this.exclusiveStartShardId = exclusiveStartShardId;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final Instant getStreamCreationTimestamp() {
            return this.streamCreationTimestamp;
        }

        @Override
        public final Builder streamCreationTimestamp(Instant streamCreationTimestamp) {
            this.streamCreationTimestamp = streamCreationTimestamp;
            return this;
        }

        public final void setStreamCreationTimestamp(Instant streamCreationTimestamp) {
            this.streamCreationTimestamp = streamCreationTimestamp;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListShardsRequest build() {
            return new ListShardsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KinesisRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListShardsRequest> {
        public Builder streamName(String var1);

        public Builder nextToken(String var1);

        public Builder exclusiveStartShardId(String var1);

        public Builder maxResults(Integer var1);

        public Builder streamCreationTimestamp(Instant var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

