/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesis.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesis.model.KinesisRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeStreamSummaryRequest
extends KinesisRequest
implements ToCopyableBuilder<Builder, DescribeStreamSummaryRequest> {
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeStreamSummaryRequest.getter(DescribeStreamSummaryRequest::streamName)).setter(DescribeStreamSummaryRequest.setter(Builder::streamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAME_FIELD));
    private final String streamName;

    private DescribeStreamSummaryRequest(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
    }

    public String streamName() {
        return this.streamName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStreamSummaryRequest)) {
            return false;
        }
        DescribeStreamSummaryRequest other = (DescribeStreamSummaryRequest)((Object)obj);
        return Objects.equals(this.streamName(), other.streamName());
    }

    public String toString() {
        return ToString.builder((String)"DescribeStreamSummaryRequest").add("StreamName", (Object)this.streamName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamName": {
                return Optional.ofNullable(clazz.cast(this.streamName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeStreamSummaryRequest, T> g) {
        return obj -> g.apply((DescribeStreamSummaryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisRequest.BuilderImpl
    implements Builder {
        private String streamName;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStreamSummaryRequest model) {
            super(model);
            this.streamName(model.streamName);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeStreamSummaryRequest build() {
            return new DescribeStreamSummaryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KinesisRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeStreamSummaryRequest> {
        public Builder streamName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

