/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.keyspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Point-in-time recovery (PITR) helps protect your Amazon Keyspaces tables from accidental write or delete operations
 * by providing you continuous backups of your table data.
 * </p>
 * <p>
 * For more information, see <a
 * href="https://docs.aws.amazon.com/keyspaces/latest/devguide/PointInTimeRecovery.html">Point-in-time recovery</a> in
 * the <i>Amazon Keyspaces Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PointInTimeRecovery implements SdkPojo, Serializable,
        ToCopyableBuilder<PointInTimeRecovery.Builder, PointInTimeRecovery> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(PointInTimeRecovery::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String status;

    private PointInTimeRecovery(BuilderImpl builder) {
        this.status = builder.status;
    }

    /**
     * <p>
     * The options are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>status=ENABLED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>status=DISABLED</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PointInTimeRecoveryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The options are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>status=ENABLED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>status=DISABLED</code>
     *         </p>
     *         </li>
     * @see PointInTimeRecoveryStatus
     */
    public final PointInTimeRecoveryStatus status() {
        return PointInTimeRecoveryStatus.fromValue(status);
    }

    /**
     * <p>
     * The options are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>status=ENABLED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>status=DISABLED</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PointInTimeRecoveryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The options are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>status=ENABLED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>status=DISABLED</code>
     *         </p>
     *         </li>
     * @see PointInTimeRecoveryStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PointInTimeRecovery)) {
            return false;
        }
        PointInTimeRecovery other = (PointInTimeRecovery) obj;
        return Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PointInTimeRecovery").add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PointInTimeRecovery, T> g) {
        return obj -> g.apply((PointInTimeRecovery) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PointInTimeRecovery> {
        /**
         * <p>
         * The options are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>status=ENABLED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status=DISABLED</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The options are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>status=ENABLED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>status=DISABLED</code>
         *        </p>
         *        </li>
         * @see PointInTimeRecoveryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PointInTimeRecoveryStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The options are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>status=ENABLED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status=DISABLED</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The options are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>status=ENABLED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>status=DISABLED</code>
         *        </p>
         *        </li>
         * @see PointInTimeRecoveryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PointInTimeRecoveryStatus
         */
        Builder status(PointInTimeRecoveryStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(PointInTimeRecovery model) {
            status(model.status);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PointInTimeRecoveryStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public PointInTimeRecovery build() {
            return new PointInTimeRecovery(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
