/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.keyspaces.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.keyspaces.model.KeyspacesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTableRequest
extends KeyspacesRequest
implements ToCopyableBuilder<Builder, GetTableRequest> {
    private static final SdkField<String> KEYSPACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("keyspaceName").getter(GetTableRequest.getter(GetTableRequest::keyspaceName)).setter(GetTableRequest.setter(Builder::keyspaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyspaceName").build()}).build();
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tableName").getter(GetTableRequest.getter(GetTableRequest::tableName)).setter(GetTableRequest.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEYSPACE_NAME_FIELD, TABLE_NAME_FIELD));
    private final String keyspaceName;
    private final String tableName;

    private GetTableRequest(BuilderImpl builder) {
        super(builder);
        this.keyspaceName = builder.keyspaceName;
        this.tableName = builder.tableName;
    }

    public final String keyspaceName() {
        return this.keyspaceName;
    }

    public final String tableName() {
        return this.tableName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keyspaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTableRequest)) {
            return false;
        }
        GetTableRequest other = (GetTableRequest)((Object)obj);
        return Objects.equals(this.keyspaceName(), other.keyspaceName()) && Objects.equals(this.tableName(), other.tableName());
    }

    public final String toString() {
        return ToString.builder((String)"GetTableRequest").add("KeyspaceName", (Object)this.keyspaceName()).add("TableName", (Object)this.tableName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "keyspaceName": {
                return Optional.ofNullable(clazz.cast(this.keyspaceName()));
            }
            case "tableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTableRequest, T> g) {
        return obj -> g.apply((GetTableRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KeyspacesRequest.BuilderImpl
    implements Builder {
        private String keyspaceName;
        private String tableName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTableRequest model) {
            super(model);
            this.keyspaceName(model.keyspaceName);
            this.tableName(model.tableName);
        }

        public final String getKeyspaceName() {
            return this.keyspaceName;
        }

        public final void setKeyspaceName(String keyspaceName) {
            this.keyspaceName = keyspaceName;
        }

        @Override
        public final Builder keyspaceName(String keyspaceName) {
            this.keyspaceName = keyspaceName;
            return this;
        }

        public final String getTableName() {
            return this.tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetTableRequest build() {
            return new GetTableRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KeyspacesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTableRequest> {
        public Builder keyspaceName(String var1);

        public Builder tableName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

