/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendraranking;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.kendraranking.DefaultKendraRankingAsyncClient;
import software.amazon.awssdk.services.kendraranking.DefaultKendraRankingBaseClientBuilder;
import software.amazon.awssdk.services.kendraranking.KendraRankingAsyncClient;
import software.amazon.awssdk.services.kendraranking.KendraRankingAsyncClientBuilder;
import software.amazon.awssdk.services.kendraranking.KendraRankingServiceClientConfiguration;
import software.amazon.awssdk.services.kendraranking.endpoints.KendraRankingEndpointProvider;

@SdkInternalApi
final class DefaultKendraRankingAsyncClientBuilder
extends DefaultKendraRankingBaseClientBuilder<KendraRankingAsyncClientBuilder, KendraRankingAsyncClient>
implements KendraRankingAsyncClientBuilder {
    DefaultKendraRankingAsyncClientBuilder() {
    }

    @Override
    public DefaultKendraRankingAsyncClientBuilder endpointProvider(KendraRankingEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final KendraRankingAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultKendraRankingAsyncClientBuilder.validateClientOptions(clientConfiguration);
        KendraRankingServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultKendraRankingAsyncClient client = new DefaultKendraRankingAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private KendraRankingServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return KendraRankingServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

