/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum HighlightType {
    STANDARD("STANDARD"),
    THESAURUS_SYNONYM("THESAURUS_SYNONYM"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, HighlightType> VALUE_MAP;
    private final String value;

    private HighlightType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HighlightType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HighlightType> knownValues() {
        EnumSet<HighlightType> knownValues = EnumSet.allOf(HighlightType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(HighlightType.class, HighlightType::toString);
    }
}

