/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A single query result.
 * </p>
 * <p>
 * A query result contains information about a document returned by the query. This includes the original location of
 * the document, a list of attributes assigned to the document, and relevant text from the document that satisfies the
 * query.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueryResultItem implements SdkPojo, Serializable, ToCopyableBuilder<QueryResultItem.Builder, QueryResultItem> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(QueryResultItem::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(QueryResultItem::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Format")
            .getter(getter(QueryResultItem::formatAsString)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").build()).build();

    private static final SdkField<List<AdditionalResultAttribute>> ADDITIONAL_ATTRIBUTES_FIELD = SdkField
            .<List<AdditionalResultAttribute>> builder(MarshallingType.LIST)
            .memberName("AdditionalAttributes")
            .getter(getter(QueryResultItem::additionalAttributes))
            .setter(setter(Builder::additionalAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AdditionalResultAttribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(AdditionalResultAttribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DOCUMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentId").getter(getter(QueryResultItem::documentId)).setter(setter(Builder::documentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentId").build()).build();

    private static final SdkField<TextWithHighlights> DOCUMENT_TITLE_FIELD = SdkField
            .<TextWithHighlights> builder(MarshallingType.SDK_POJO).memberName("DocumentTitle")
            .getter(getter(QueryResultItem::documentTitle)).setter(setter(Builder::documentTitle))
            .constructor(TextWithHighlights::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentTitle").build()).build();

    private static final SdkField<TextWithHighlights> DOCUMENT_EXCERPT_FIELD = SdkField
            .<TextWithHighlights> builder(MarshallingType.SDK_POJO).memberName("DocumentExcerpt")
            .getter(getter(QueryResultItem::documentExcerpt)).setter(setter(Builder::documentExcerpt))
            .constructor(TextWithHighlights::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentExcerpt").build()).build();

    private static final SdkField<String> DOCUMENT_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentURI").getter(getter(QueryResultItem::documentURI)).setter(setter(Builder::documentURI))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentURI").build()).build();

    private static final SdkField<List<DocumentAttribute>> DOCUMENT_ATTRIBUTES_FIELD = SdkField
            .<List<DocumentAttribute>> builder(MarshallingType.LIST)
            .memberName("DocumentAttributes")
            .getter(getter(QueryResultItem::documentAttributes))
            .setter(setter(Builder::documentAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DocumentAttribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(DocumentAttribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ScoreAttributes> SCORE_ATTRIBUTES_FIELD = SdkField
            .<ScoreAttributes> builder(MarshallingType.SDK_POJO).memberName("ScoreAttributes")
            .getter(getter(QueryResultItem::scoreAttributes)).setter(setter(Builder::scoreAttributes))
            .constructor(ScoreAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScoreAttributes").build()).build();

    private static final SdkField<String> FEEDBACK_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FeedbackToken").getter(getter(QueryResultItem::feedbackToken)).setter(setter(Builder::feedbackToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeedbackToken").build()).build();

    private static final SdkField<TableExcerpt> TABLE_EXCERPT_FIELD = SdkField.<TableExcerpt> builder(MarshallingType.SDK_POJO)
            .memberName("TableExcerpt").getter(getter(QueryResultItem::tableExcerpt)).setter(setter(Builder::tableExcerpt))
            .constructor(TableExcerpt::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableExcerpt").build()).build();

    private static final SdkField<CollapsedResultDetail> COLLAPSED_RESULT_DETAIL_FIELD = SdkField
            .<CollapsedResultDetail> builder(MarshallingType.SDK_POJO).memberName("CollapsedResultDetail")
            .getter(getter(QueryResultItem::collapsedResultDetail)).setter(setter(Builder::collapsedResultDetail))
            .constructor(CollapsedResultDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CollapsedResultDetail").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TYPE_FIELD,
            FORMAT_FIELD, ADDITIONAL_ATTRIBUTES_FIELD, DOCUMENT_ID_FIELD, DOCUMENT_TITLE_FIELD, DOCUMENT_EXCERPT_FIELD,
            DOCUMENT_URI_FIELD, DOCUMENT_ATTRIBUTES_FIELD, SCORE_ATTRIBUTES_FIELD, FEEDBACK_TOKEN_FIELD, TABLE_EXCERPT_FIELD,
            COLLAPSED_RESULT_DETAIL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String type;

    private final String format;

    private final List<AdditionalResultAttribute> additionalAttributes;

    private final String documentId;

    private final TextWithHighlights documentTitle;

    private final TextWithHighlights documentExcerpt;

    private final String documentURI;

    private final List<DocumentAttribute> documentAttributes;

    private final ScoreAttributes scoreAttributes;

    private final String feedbackToken;

    private final TableExcerpt tableExcerpt;

    private final CollapsedResultDetail collapsedResultDetail;

    private QueryResultItem(BuilderImpl builder) {
        this.id = builder.id;
        this.type = builder.type;
        this.format = builder.format;
        this.additionalAttributes = builder.additionalAttributes;
        this.documentId = builder.documentId;
        this.documentTitle = builder.documentTitle;
        this.documentExcerpt = builder.documentExcerpt;
        this.documentURI = builder.documentURI;
        this.documentAttributes = builder.documentAttributes;
        this.scoreAttributes = builder.scoreAttributes;
        this.feedbackToken = builder.feedbackToken;
        this.tableExcerpt = builder.tableExcerpt;
        this.collapsedResultDetail = builder.collapsedResultDetail;
    }

    /**
     * <p>
     * The identifier for the query result.
     * </p>
     * 
     * @return The identifier for the query result.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The type of document within the response. For example, a response could include a question-answer that's relevant
     * to the query.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link QueryResultType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of document within the response. For example, a response could include a question-answer that's
     *         relevant to the query.
     * @see QueryResultType
     */
    public final QueryResultType type() {
        return QueryResultType.fromValue(type);
    }

    /**
     * <p>
     * The type of document within the response. For example, a response could include a question-answer that's relevant
     * to the query.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link QueryResultType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of document within the response. For example, a response could include a question-answer that's
     *         relevant to the query.
     * @see QueryResultType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * If the <code>Type</code> of document within the response is <code>ANSWER</code>, then it is either a
     * <code>TABLE</code> answer or <code>TEXT</code> answer. If it's a table answer, a table excerpt is returned in
     * <code>TableExcerpt</code>. If it's a text answer, a text excerpt is returned in <code>DocumentExcerpt</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link QueryResultFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return If the <code>Type</code> of document within the response is <code>ANSWER</code>, then it is either a
     *         <code>TABLE</code> answer or <code>TEXT</code> answer. If it's a table answer, a table excerpt is
     *         returned in <code>TableExcerpt</code>. If it's a text answer, a text excerpt is returned in
     *         <code>DocumentExcerpt</code>.
     * @see QueryResultFormat
     */
    public final QueryResultFormat format() {
        return QueryResultFormat.fromValue(format);
    }

    /**
     * <p>
     * If the <code>Type</code> of document within the response is <code>ANSWER</code>, then it is either a
     * <code>TABLE</code> answer or <code>TEXT</code> answer. If it's a table answer, a table excerpt is returned in
     * <code>TableExcerpt</code>. If it's a text answer, a text excerpt is returned in <code>DocumentExcerpt</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link QueryResultFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return If the <code>Type</code> of document within the response is <code>ANSWER</code>, then it is either a
     *         <code>TABLE</code> answer or <code>TEXT</code> answer. If it's a table answer, a table excerpt is
     *         returned in <code>TableExcerpt</code>. If it's a text answer, a text excerpt is returned in
     *         <code>DocumentExcerpt</code>.
     * @see QueryResultFormat
     */
    public final String formatAsString() {
        return format;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalAttributes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAdditionalAttributes() {
        return additionalAttributes != null && !(additionalAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more additional fields/attributes associated with the query result.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalAttributes} method.
     * </p>
     * 
     * @return One or more additional fields/attributes associated with the query result.
     */
    public final List<AdditionalResultAttribute> additionalAttributes() {
        return additionalAttributes;
    }

    /**
     * <p>
     * The identifier for the document.
     * </p>
     * 
     * @return The identifier for the document.
     */
    public final String documentId() {
        return documentId;
    }

    /**
     * <p>
     * The title of the document. Contains the text of the title and information for highlighting the relevant terms in
     * the title.
     * </p>
     * 
     * @return The title of the document. Contains the text of the title and information for highlighting the relevant
     *         terms in the title.
     */
    public final TextWithHighlights documentTitle() {
        return documentTitle;
    }

    /**
     * <p>
     * An extract of the text in the document. Contains information about highlighting the relevant terms in the
     * excerpt.
     * </p>
     * 
     * @return An extract of the text in the document. Contains information about highlighting the relevant terms in the
     *         excerpt.
     */
    public final TextWithHighlights documentExcerpt() {
        return documentExcerpt;
    }

    /**
     * <p>
     * The URI of the original location of the document.
     * </p>
     * 
     * @return The URI of the original location of the document.
     */
    public final String documentURI() {
        return documentURI;
    }

    /**
     * For responses, this returns true if the service returned a value for the DocumentAttributes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDocumentAttributes() {
        return documentAttributes != null && !(documentAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of document fields/attributes assigned to a document in the search results. For example, the document
     * author (<code>_author</code>) or the source URI (<code>_source_uri</code>) of the document.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDocumentAttributes} method.
     * </p>
     * 
     * @return An array of document fields/attributes assigned to a document in the search results. For example, the
     *         document author (<code>_author</code>) or the source URI (<code>_source_uri</code>) of the document.
     */
    public final List<DocumentAttribute> documentAttributes() {
        return documentAttributes;
    }

    /**
     * <p>
     * Indicates the confidence level of Amazon Kendra providing a relevant result for the query. Each result is placed
     * into a bin that indicates the confidence, <code>VERY_HIGH</code>, <code>HIGH</code>, <code>MEDIUM</code> and
     * <code>LOW</code>. You can use the score to determine if a response meets the confidence needed for your
     * application.
     * </p>
     * <p>
     * The field is only set to <code>LOW</code> when the <code>Type</code> field is set to <code>DOCUMENT</code> and
     * Amazon Kendra is not confident that the result is relevant to the query.
     * </p>
     * 
     * @return Indicates the confidence level of Amazon Kendra providing a relevant result for the query. Each result is
     *         placed into a bin that indicates the confidence, <code>VERY_HIGH</code>, <code>HIGH</code>,
     *         <code>MEDIUM</code> and <code>LOW</code>. You can use the score to determine if a response meets the
     *         confidence needed for your application.</p>
     *         <p>
     *         The field is only set to <code>LOW</code> when the <code>Type</code> field is set to
     *         <code>DOCUMENT</code> and Amazon Kendra is not confident that the result is relevant to the query.
     */
    public final ScoreAttributes scoreAttributes() {
        return scoreAttributes;
    }

    /**
     * <p>
     * A token that identifies a particular result from a particular query. Use this token to provide click-through
     * feedback for the result. For more information, see <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/submitting-feedback.html">Submitting feedback</a>.
     * </p>
     * 
     * @return A token that identifies a particular result from a particular query. Use this token to provide
     *         click-through feedback for the result. For more information, see <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/submitting-feedback.html">Submitting feedback</a>.
     */
    public final String feedbackToken() {
        return feedbackToken;
    }

    /**
     * <p>
     * An excerpt from a table within a document.
     * </p>
     * 
     * @return An excerpt from a table within a document.
     */
    public final TableExcerpt tableExcerpt() {
        return tableExcerpt;
    }

    /**
     * <p>
     * Provides details about a collapsed group of search results.
     * </p>
     * 
     * @return Provides details about a collapsed group of search results.
     */
    public final CollapsedResultDetail collapsedResultDetail() {
        return collapsedResultDetail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalAttributes() ? additionalAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(documentId());
        hashCode = 31 * hashCode + Objects.hashCode(documentTitle());
        hashCode = 31 * hashCode + Objects.hashCode(documentExcerpt());
        hashCode = 31 * hashCode + Objects.hashCode(documentURI());
        hashCode = 31 * hashCode + Objects.hashCode(hasDocumentAttributes() ? documentAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(scoreAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(feedbackToken());
        hashCode = 31 * hashCode + Objects.hashCode(tableExcerpt());
        hashCode = 31 * hashCode + Objects.hashCode(collapsedResultDetail());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryResultItem)) {
            return false;
        }
        QueryResultItem other = (QueryResultItem) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(formatAsString(), other.formatAsString())
                && hasAdditionalAttributes() == other.hasAdditionalAttributes()
                && Objects.equals(additionalAttributes(), other.additionalAttributes())
                && Objects.equals(documentId(), other.documentId()) && Objects.equals(documentTitle(), other.documentTitle())
                && Objects.equals(documentExcerpt(), other.documentExcerpt())
                && Objects.equals(documentURI(), other.documentURI()) && hasDocumentAttributes() == other.hasDocumentAttributes()
                && Objects.equals(documentAttributes(), other.documentAttributes())
                && Objects.equals(scoreAttributes(), other.scoreAttributes())
                && Objects.equals(feedbackToken(), other.feedbackToken()) && Objects.equals(tableExcerpt(), other.tableExcerpt())
                && Objects.equals(collapsedResultDetail(), other.collapsedResultDetail());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QueryResultItem").add("Id", id()).add("Type", typeAsString()).add("Format", formatAsString())
                .add("AdditionalAttributes", hasAdditionalAttributes() ? additionalAttributes() : null)
                .add("DocumentId", documentId()).add("DocumentTitle", documentTitle()).add("DocumentExcerpt", documentExcerpt())
                .add("DocumentURI", documentURI())
                .add("DocumentAttributes", hasDocumentAttributes() ? documentAttributes() : null)
                .add("ScoreAttributes", scoreAttributes()).add("FeedbackToken", feedbackToken())
                .add("TableExcerpt", tableExcerpt()).add("CollapsedResultDetail", collapsedResultDetail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Format":
            return Optional.ofNullable(clazz.cast(formatAsString()));
        case "AdditionalAttributes":
            return Optional.ofNullable(clazz.cast(additionalAttributes()));
        case "DocumentId":
            return Optional.ofNullable(clazz.cast(documentId()));
        case "DocumentTitle":
            return Optional.ofNullable(clazz.cast(documentTitle()));
        case "DocumentExcerpt":
            return Optional.ofNullable(clazz.cast(documentExcerpt()));
        case "DocumentURI":
            return Optional.ofNullable(clazz.cast(documentURI()));
        case "DocumentAttributes":
            return Optional.ofNullable(clazz.cast(documentAttributes()));
        case "ScoreAttributes":
            return Optional.ofNullable(clazz.cast(scoreAttributes()));
        case "FeedbackToken":
            return Optional.ofNullable(clazz.cast(feedbackToken()));
        case "TableExcerpt":
            return Optional.ofNullable(clazz.cast(tableExcerpt()));
        case "CollapsedResultDetail":
            return Optional.ofNullable(clazz.cast(collapsedResultDetail()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueryResultItem, T> g) {
        return obj -> g.apply((QueryResultItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QueryResultItem> {
        /**
         * <p>
         * The identifier for the query result.
         * </p>
         * 
         * @param id
         *        The identifier for the query result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The type of document within the response. For example, a response could include a question-answer that's
         * relevant to the query.
         * </p>
         * 
         * @param type
         *        The type of document within the response. For example, a response could include a question-answer
         *        that's relevant to the query.
         * @see QueryResultType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryResultType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of document within the response. For example, a response could include a question-answer that's
         * relevant to the query.
         * </p>
         * 
         * @param type
         *        The type of document within the response. For example, a response could include a question-answer
         *        that's relevant to the query.
         * @see QueryResultType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryResultType
         */
        Builder type(QueryResultType type);

        /**
         * <p>
         * If the <code>Type</code> of document within the response is <code>ANSWER</code>, then it is either a
         * <code>TABLE</code> answer or <code>TEXT</code> answer. If it's a table answer, a table excerpt is returned in
         * <code>TableExcerpt</code>. If it's a text answer, a text excerpt is returned in <code>DocumentExcerpt</code>.
         * </p>
         * 
         * @param format
         *        If the <code>Type</code> of document within the response is <code>ANSWER</code>, then it is either a
         *        <code>TABLE</code> answer or <code>TEXT</code> answer. If it's a table answer, a table excerpt is
         *        returned in <code>TableExcerpt</code>. If it's a text answer, a text excerpt is returned in
         *        <code>DocumentExcerpt</code>.
         * @see QueryResultFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryResultFormat
         */
        Builder format(String format);

        /**
         * <p>
         * If the <code>Type</code> of document within the response is <code>ANSWER</code>, then it is either a
         * <code>TABLE</code> answer or <code>TEXT</code> answer. If it's a table answer, a table excerpt is returned in
         * <code>TableExcerpt</code>. If it's a text answer, a text excerpt is returned in <code>DocumentExcerpt</code>.
         * </p>
         * 
         * @param format
         *        If the <code>Type</code> of document within the response is <code>ANSWER</code>, then it is either a
         *        <code>TABLE</code> answer or <code>TEXT</code> answer. If it's a table answer, a table excerpt is
         *        returned in <code>TableExcerpt</code>. If it's a text answer, a text excerpt is returned in
         *        <code>DocumentExcerpt</code>.
         * @see QueryResultFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryResultFormat
         */
        Builder format(QueryResultFormat format);

        /**
         * <p>
         * One or more additional fields/attributes associated with the query result.
         * </p>
         * 
         * @param additionalAttributes
         *        One or more additional fields/attributes associated with the query result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalAttributes(Collection<AdditionalResultAttribute> additionalAttributes);

        /**
         * <p>
         * One or more additional fields/attributes associated with the query result.
         * </p>
         * 
         * @param additionalAttributes
         *        One or more additional fields/attributes associated with the query result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalAttributes(AdditionalResultAttribute... additionalAttributes);

        /**
         * <p>
         * One or more additional fields/attributes associated with the query result.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kendra.model.AdditionalResultAttribute.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.kendra.model.AdditionalResultAttribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kendra.model.AdditionalResultAttribute.Builder#build()} is called
         * immediately and its result is passed to {@link #additionalAttributes(List<AdditionalResultAttribute>)}.
         * 
         * @param additionalAttributes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kendra.model.AdditionalResultAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #additionalAttributes(java.util.Collection<AdditionalResultAttribute>)
         */
        Builder additionalAttributes(Consumer<AdditionalResultAttribute.Builder>... additionalAttributes);

        /**
         * <p>
         * The identifier for the document.
         * </p>
         * 
         * @param documentId
         *        The identifier for the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentId(String documentId);

        /**
         * <p>
         * The title of the document. Contains the text of the title and information for highlighting the relevant terms
         * in the title.
         * </p>
         * 
         * @param documentTitle
         *        The title of the document. Contains the text of the title and information for highlighting the
         *        relevant terms in the title.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentTitle(TextWithHighlights documentTitle);

        /**
         * <p>
         * The title of the document. Contains the text of the title and information for highlighting the relevant terms
         * in the title.
         * </p>
         * This is a convenience method that creates an instance of the {@link TextWithHighlights.Builder} avoiding the
         * need to create one manually via {@link TextWithHighlights#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TextWithHighlights.Builder#build()} is called immediately and its
         * result is passed to {@link #documentTitle(TextWithHighlights)}.
         * 
         * @param documentTitle
         *        a consumer that will call methods on {@link TextWithHighlights.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentTitle(TextWithHighlights)
         */
        default Builder documentTitle(Consumer<TextWithHighlights.Builder> documentTitle) {
            return documentTitle(TextWithHighlights.builder().applyMutation(documentTitle).build());
        }

        /**
         * <p>
         * An extract of the text in the document. Contains information about highlighting the relevant terms in the
         * excerpt.
         * </p>
         * 
         * @param documentExcerpt
         *        An extract of the text in the document. Contains information about highlighting the relevant terms in
         *        the excerpt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentExcerpt(TextWithHighlights documentExcerpt);

        /**
         * <p>
         * An extract of the text in the document. Contains information about highlighting the relevant terms in the
         * excerpt.
         * </p>
         * This is a convenience method that creates an instance of the {@link TextWithHighlights.Builder} avoiding the
         * need to create one manually via {@link TextWithHighlights#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TextWithHighlights.Builder#build()} is called immediately and its
         * result is passed to {@link #documentExcerpt(TextWithHighlights)}.
         * 
         * @param documentExcerpt
         *        a consumer that will call methods on {@link TextWithHighlights.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentExcerpt(TextWithHighlights)
         */
        default Builder documentExcerpt(Consumer<TextWithHighlights.Builder> documentExcerpt) {
            return documentExcerpt(TextWithHighlights.builder().applyMutation(documentExcerpt).build());
        }

        /**
         * <p>
         * The URI of the original location of the document.
         * </p>
         * 
         * @param documentURI
         *        The URI of the original location of the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentURI(String documentURI);

        /**
         * <p>
         * An array of document fields/attributes assigned to a document in the search results. For example, the
         * document author (<code>_author</code>) or the source URI (<code>_source_uri</code>) of the document.
         * </p>
         * 
         * @param documentAttributes
         *        An array of document fields/attributes assigned to a document in the search results. For example, the
         *        document author (<code>_author</code>) or the source URI (<code>_source_uri</code>) of the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentAttributes(Collection<DocumentAttribute> documentAttributes);

        /**
         * <p>
         * An array of document fields/attributes assigned to a document in the search results. For example, the
         * document author (<code>_author</code>) or the source URI (<code>_source_uri</code>) of the document.
         * </p>
         * 
         * @param documentAttributes
         *        An array of document fields/attributes assigned to a document in the search results. For example, the
         *        document author (<code>_author</code>) or the source URI (<code>_source_uri</code>) of the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentAttributes(DocumentAttribute... documentAttributes);

        /**
         * <p>
         * An array of document fields/attributes assigned to a document in the search results. For example, the
         * document author (<code>_author</code>) or the source URI (<code>_source_uri</code>) of the document.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kendra.model.DocumentAttribute.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.kendra.model.DocumentAttribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kendra.model.DocumentAttribute.Builder#build()} is called immediately
         * and its result is passed to {@link #documentAttributes(List<DocumentAttribute>)}.
         * 
         * @param documentAttributes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kendra.model.DocumentAttribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentAttributes(java.util.Collection<DocumentAttribute>)
         */
        Builder documentAttributes(Consumer<DocumentAttribute.Builder>... documentAttributes);

        /**
         * <p>
         * Indicates the confidence level of Amazon Kendra providing a relevant result for the query. Each result is
         * placed into a bin that indicates the confidence, <code>VERY_HIGH</code>, <code>HIGH</code>,
         * <code>MEDIUM</code> and <code>LOW</code>. You can use the score to determine if a response meets the
         * confidence needed for your application.
         * </p>
         * <p>
         * The field is only set to <code>LOW</code> when the <code>Type</code> field is set to <code>DOCUMENT</code>
         * and Amazon Kendra is not confident that the result is relevant to the query.
         * </p>
         * 
         * @param scoreAttributes
         *        Indicates the confidence level of Amazon Kendra providing a relevant result for the query. Each result
         *        is placed into a bin that indicates the confidence, <code>VERY_HIGH</code>, <code>HIGH</code>,
         *        <code>MEDIUM</code> and <code>LOW</code>. You can use the score to determine if a response meets the
         *        confidence needed for your application.</p>
         *        <p>
         *        The field is only set to <code>LOW</code> when the <code>Type</code> field is set to
         *        <code>DOCUMENT</code> and Amazon Kendra is not confident that the result is relevant to the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scoreAttributes(ScoreAttributes scoreAttributes);

        /**
         * <p>
         * Indicates the confidence level of Amazon Kendra providing a relevant result for the query. Each result is
         * placed into a bin that indicates the confidence, <code>VERY_HIGH</code>, <code>HIGH</code>,
         * <code>MEDIUM</code> and <code>LOW</code>. You can use the score to determine if a response meets the
         * confidence needed for your application.
         * </p>
         * <p>
         * The field is only set to <code>LOW</code> when the <code>Type</code> field is set to <code>DOCUMENT</code>
         * and Amazon Kendra is not confident that the result is relevant to the query.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScoreAttributes.Builder} avoiding the
         * need to create one manually via {@link ScoreAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScoreAttributes.Builder#build()} is called immediately and its
         * result is passed to {@link #scoreAttributes(ScoreAttributes)}.
         * 
         * @param scoreAttributes
         *        a consumer that will call methods on {@link ScoreAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scoreAttributes(ScoreAttributes)
         */
        default Builder scoreAttributes(Consumer<ScoreAttributes.Builder> scoreAttributes) {
            return scoreAttributes(ScoreAttributes.builder().applyMutation(scoreAttributes).build());
        }

        /**
         * <p>
         * A token that identifies a particular result from a particular query. Use this token to provide click-through
         * feedback for the result. For more information, see <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/submitting-feedback.html">Submitting feedback</a>.
         * </p>
         * 
         * @param feedbackToken
         *        A token that identifies a particular result from a particular query. Use this token to provide
         *        click-through feedback for the result. For more information, see <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/submitting-feedback.html">Submitting feedback</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder feedbackToken(String feedbackToken);

        /**
         * <p>
         * An excerpt from a table within a document.
         * </p>
         * 
         * @param tableExcerpt
         *        An excerpt from a table within a document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableExcerpt(TableExcerpt tableExcerpt);

        /**
         * <p>
         * An excerpt from a table within a document.
         * </p>
         * This is a convenience method that creates an instance of the {@link TableExcerpt.Builder} avoiding the need
         * to create one manually via {@link TableExcerpt#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TableExcerpt.Builder#build()} is called immediately and its
         * result is passed to {@link #tableExcerpt(TableExcerpt)}.
         * 
         * @param tableExcerpt
         *        a consumer that will call methods on {@link TableExcerpt.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tableExcerpt(TableExcerpt)
         */
        default Builder tableExcerpt(Consumer<TableExcerpt.Builder> tableExcerpt) {
            return tableExcerpt(TableExcerpt.builder().applyMutation(tableExcerpt).build());
        }

        /**
         * <p>
         * Provides details about a collapsed group of search results.
         * </p>
         * 
         * @param collapsedResultDetail
         *        Provides details about a collapsed group of search results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collapsedResultDetail(CollapsedResultDetail collapsedResultDetail);

        /**
         * <p>
         * Provides details about a collapsed group of search results.
         * </p>
         * This is a convenience method that creates an instance of the {@link CollapsedResultDetail.Builder} avoiding
         * the need to create one manually via {@link CollapsedResultDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CollapsedResultDetail.Builder#build()} is called immediately and
         * its result is passed to {@link #collapsedResultDetail(CollapsedResultDetail)}.
         * 
         * @param collapsedResultDetail
         *        a consumer that will call methods on {@link CollapsedResultDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #collapsedResultDetail(CollapsedResultDetail)
         */
        default Builder collapsedResultDetail(Consumer<CollapsedResultDetail.Builder> collapsedResultDetail) {
            return collapsedResultDetail(CollapsedResultDetail.builder().applyMutation(collapsedResultDetail).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String type;

        private String format;

        private List<AdditionalResultAttribute> additionalAttributes = DefaultSdkAutoConstructList.getInstance();

        private String documentId;

        private TextWithHighlights documentTitle;

        private TextWithHighlights documentExcerpt;

        private String documentURI;

        private List<DocumentAttribute> documentAttributes = DefaultSdkAutoConstructList.getInstance();

        private ScoreAttributes scoreAttributes;

        private String feedbackToken;

        private TableExcerpt tableExcerpt;

        private CollapsedResultDetail collapsedResultDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryResultItem model) {
            id(model.id);
            type(model.type);
            format(model.format);
            additionalAttributes(model.additionalAttributes);
            documentId(model.documentId);
            documentTitle(model.documentTitle);
            documentExcerpt(model.documentExcerpt);
            documentURI(model.documentURI);
            documentAttributes(model.documentAttributes);
            scoreAttributes(model.scoreAttributes);
            feedbackToken(model.feedbackToken);
            tableExcerpt(model.tableExcerpt);
            collapsedResultDetail(model.collapsedResultDetail);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(QueryResultType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(QueryResultFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final List<AdditionalResultAttribute.Builder> getAdditionalAttributes() {
            List<AdditionalResultAttribute.Builder> result = AdditionalResultAttributeListCopier
                    .copyToBuilder(this.additionalAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdditionalAttributes(Collection<AdditionalResultAttribute.BuilderImpl> additionalAttributes) {
            this.additionalAttributes = AdditionalResultAttributeListCopier.copyFromBuilder(additionalAttributes);
        }

        @Override
        public final Builder additionalAttributes(Collection<AdditionalResultAttribute> additionalAttributes) {
            this.additionalAttributes = AdditionalResultAttributeListCopier.copy(additionalAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalAttributes(AdditionalResultAttribute... additionalAttributes) {
            additionalAttributes(Arrays.asList(additionalAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalAttributes(Consumer<AdditionalResultAttribute.Builder>... additionalAttributes) {
            additionalAttributes(Stream.of(additionalAttributes)
                    .map(c -> AdditionalResultAttribute.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDocumentId() {
            return documentId;
        }

        public final void setDocumentId(String documentId) {
            this.documentId = documentId;
        }

        @Override
        public final Builder documentId(String documentId) {
            this.documentId = documentId;
            return this;
        }

        public final TextWithHighlights.Builder getDocumentTitle() {
            return documentTitle != null ? documentTitle.toBuilder() : null;
        }

        public final void setDocumentTitle(TextWithHighlights.BuilderImpl documentTitle) {
            this.documentTitle = documentTitle != null ? documentTitle.build() : null;
        }

        @Override
        public final Builder documentTitle(TextWithHighlights documentTitle) {
            this.documentTitle = documentTitle;
            return this;
        }

        public final TextWithHighlights.Builder getDocumentExcerpt() {
            return documentExcerpt != null ? documentExcerpt.toBuilder() : null;
        }

        public final void setDocumentExcerpt(TextWithHighlights.BuilderImpl documentExcerpt) {
            this.documentExcerpt = documentExcerpt != null ? documentExcerpt.build() : null;
        }

        @Override
        public final Builder documentExcerpt(TextWithHighlights documentExcerpt) {
            this.documentExcerpt = documentExcerpt;
            return this;
        }

        public final String getDocumentURI() {
            return documentURI;
        }

        public final void setDocumentURI(String documentURI) {
            this.documentURI = documentURI;
        }

        @Override
        public final Builder documentURI(String documentURI) {
            this.documentURI = documentURI;
            return this;
        }

        public final List<DocumentAttribute.Builder> getDocumentAttributes() {
            List<DocumentAttribute.Builder> result = DocumentAttributeListCopier.copyToBuilder(this.documentAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDocumentAttributes(Collection<DocumentAttribute.BuilderImpl> documentAttributes) {
            this.documentAttributes = DocumentAttributeListCopier.copyFromBuilder(documentAttributes);
        }

        @Override
        public final Builder documentAttributes(Collection<DocumentAttribute> documentAttributes) {
            this.documentAttributes = DocumentAttributeListCopier.copy(documentAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentAttributes(DocumentAttribute... documentAttributes) {
            documentAttributes(Arrays.asList(documentAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentAttributes(Consumer<DocumentAttribute.Builder>... documentAttributes) {
            documentAttributes(Stream.of(documentAttributes).map(c -> DocumentAttribute.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final ScoreAttributes.Builder getScoreAttributes() {
            return scoreAttributes != null ? scoreAttributes.toBuilder() : null;
        }

        public final void setScoreAttributes(ScoreAttributes.BuilderImpl scoreAttributes) {
            this.scoreAttributes = scoreAttributes != null ? scoreAttributes.build() : null;
        }

        @Override
        public final Builder scoreAttributes(ScoreAttributes scoreAttributes) {
            this.scoreAttributes = scoreAttributes;
            return this;
        }

        public final String getFeedbackToken() {
            return feedbackToken;
        }

        public final void setFeedbackToken(String feedbackToken) {
            this.feedbackToken = feedbackToken;
        }

        @Override
        public final Builder feedbackToken(String feedbackToken) {
            this.feedbackToken = feedbackToken;
            return this;
        }

        public final TableExcerpt.Builder getTableExcerpt() {
            return tableExcerpt != null ? tableExcerpt.toBuilder() : null;
        }

        public final void setTableExcerpt(TableExcerpt.BuilderImpl tableExcerpt) {
            this.tableExcerpt = tableExcerpt != null ? tableExcerpt.build() : null;
        }

        @Override
        public final Builder tableExcerpt(TableExcerpt tableExcerpt) {
            this.tableExcerpt = tableExcerpt;
            return this;
        }

        public final CollapsedResultDetail.Builder getCollapsedResultDetail() {
            return collapsedResultDetail != null ? collapsedResultDetail.toBuilder() : null;
        }

        public final void setCollapsedResultDetail(CollapsedResultDetail.BuilderImpl collapsedResultDetail) {
            this.collapsedResultDetail = collapsedResultDetail != null ? collapsedResultDetail.build() : null;
        }

        @Override
        public final Builder collapsedResultDetail(CollapsedResultDetail collapsedResultDetail) {
            this.collapsedResultDetail = collapsedResultDetail;
            return this;
        }

        @Override
        public QueryResultItem build() {
            return new QueryResultItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
