/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the configuration information for a web proxy to connect to website hosts.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProxyConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ProxyConfiguration.Builder, ProxyConfiguration> {
    private static final SdkField<String> HOST_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Host")
            .getter(getter(ProxyConfiguration::host)).setter(setter(Builder::host))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Host").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(ProxyConfiguration::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<String> CREDENTIALS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Credentials").getter(getter(ProxyConfiguration::credentials)).setter(setter(Builder::credentials))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Credentials").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOST_FIELD, PORT_FIELD,
            CREDENTIALS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String host;

    private final Integer port;

    private final String credentials;

    private ProxyConfiguration(BuilderImpl builder) {
        this.host = builder.host;
        this.port = builder.port;
        this.credentials = builder.credentials;
    }

    /**
     * <p>
     * The name of the website host you want to connect to via a web proxy server.
     * </p>
     * <p>
     * For example, the host name of https://a.example.com/page1.html is "a.example.com".
     * </p>
     * 
     * @return The name of the website host you want to connect to via a web proxy server.</p>
     *         <p>
     *         For example, the host name of https://a.example.com/page1.html is "a.example.com".
     */
    public final String host() {
        return host;
    }

    /**
     * <p>
     * The port number of the website host you want to connect to via a web proxy server.
     * </p>
     * <p>
     * For example, the port for https://a.example.com/page1.html is 443, the standard port for HTTPS.
     * </p>
     * 
     * @return The port number of the website host you want to connect to via a web proxy server. </p>
     *         <p>
     *         For example, the port for https://a.example.com/page1.html is 443, the standard port for HTTPS.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * Your secret ARN, which you can create in <a
     * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html">Secrets Manager</a>
     * </p>
     * <p>
     * The credentials are optional. You use a secret if web proxy credentials are required to connect to a website
     * host. Amazon Kendra currently support basic authentication to connect to a web proxy server. The secret stores
     * your credentials.
     * </p>
     * 
     * @return Your secret ARN, which you can create in <a
     *         href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html">Secrets Manager</a> </p>
     *         <p>
     *         The credentials are optional. You use a secret if web proxy credentials are required to connect to a
     *         website host. Amazon Kendra currently support basic authentication to connect to a web proxy server. The
     *         secret stores your credentials.
     */
    public final String credentials() {
        return credentials;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(host());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(credentials());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProxyConfiguration)) {
            return false;
        }
        ProxyConfiguration other = (ProxyConfiguration) obj;
        return Objects.equals(host(), other.host()) && Objects.equals(port(), other.port())
                && Objects.equals(credentials(), other.credentials());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProxyConfiguration").add("Host", host()).add("Port", port()).add("Credentials", credentials())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Host":
            return Optional.ofNullable(clazz.cast(host()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "Credentials":
            return Optional.ofNullable(clazz.cast(credentials()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProxyConfiguration, T> g) {
        return obj -> g.apply((ProxyConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProxyConfiguration> {
        /**
         * <p>
         * The name of the website host you want to connect to via a web proxy server.
         * </p>
         * <p>
         * For example, the host name of https://a.example.com/page1.html is "a.example.com".
         * </p>
         * 
         * @param host
         *        The name of the website host you want to connect to via a web proxy server.</p>
         *        <p>
         *        For example, the host name of https://a.example.com/page1.html is "a.example.com".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder host(String host);

        /**
         * <p>
         * The port number of the website host you want to connect to via a web proxy server.
         * </p>
         * <p>
         * For example, the port for https://a.example.com/page1.html is 443, the standard port for HTTPS.
         * </p>
         * 
         * @param port
         *        The port number of the website host you want to connect to via a web proxy server. </p>
         *        <p>
         *        For example, the port for https://a.example.com/page1.html is 443, the standard port for HTTPS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * Your secret ARN, which you can create in <a
         * href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html">Secrets Manager</a>
         * </p>
         * <p>
         * The credentials are optional. You use a secret if web proxy credentials are required to connect to a website
         * host. Amazon Kendra currently support basic authentication to connect to a web proxy server. The secret
         * stores your credentials.
         * </p>
         * 
         * @param credentials
         *        Your secret ARN, which you can create in <a
         *        href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html">Secrets Manager</a> </p>
         *        <p>
         *        The credentials are optional. You use a secret if web proxy credentials are required to connect to a
         *        website host. Amazon Kendra currently support basic authentication to connect to a web proxy server.
         *        The secret stores your credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentials(String credentials);
    }

    static final class BuilderImpl implements Builder {
        private String host;

        private Integer port;

        private String credentials;

        private BuilderImpl() {
        }

        private BuilderImpl(ProxyConfiguration model) {
            host(model.host);
            port(model.port);
            credentials(model.credentials);
        }

        public final String getHost() {
            return host;
        }

        public final void setHost(String host) {
            this.host = host;
        }

        @Override
        public final Builder host(String host) {
            this.host = host;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getCredentials() {
            return credentials;
        }

        public final void setCredentials(String credentials) {
            this.credentials = credentials;
        }

        @Override
        public final Builder credentials(String credentials) {
            this.credentials = credentials;
            return this;
        }

        @Override
        public ProxyConfiguration build() {
            return new ProxyConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
