/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the configuration information needed to customize how collapsed search result groups expand.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExpandConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ExpandConfiguration.Builder, ExpandConfiguration> {
    private static final SdkField<Integer> MAX_RESULT_ITEMS_TO_EXPAND_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResultItemsToExpand").getter(getter(ExpandConfiguration::maxResultItemsToExpand))
            .setter(setter(Builder::maxResultItemsToExpand))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResultItemsToExpand").build())
            .build();

    private static final SdkField<Integer> MAX_EXPANDED_RESULTS_PER_ITEM_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("MaxExpandedResultsPerItem")
            .getter(getter(ExpandConfiguration::maxExpandedResultsPerItem)).setter(setter(Builder::maxExpandedResultsPerItem))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxExpandedResultsPerItem").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MAX_RESULT_ITEMS_TO_EXPAND_FIELD, MAX_EXPANDED_RESULTS_PER_ITEM_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer maxResultItemsToExpand;

    private final Integer maxExpandedResultsPerItem;

    private ExpandConfiguration(BuilderImpl builder) {
        this.maxResultItemsToExpand = builder.maxResultItemsToExpand;
        this.maxExpandedResultsPerItem = builder.maxExpandedResultsPerItem;
    }

    /**
     * <p>
     * The number of collapsed search result groups to expand. If you set this value to 10, for example, only the first
     * 10 out of 100 result groups will have expand functionality.
     * </p>
     * 
     * @return The number of collapsed search result groups to expand. If you set this value to 10, for example, only
     *         the first 10 out of 100 result groups will have expand functionality.
     */
    public final Integer maxResultItemsToExpand() {
        return maxResultItemsToExpand;
    }

    /**
     * <p>
     * The number of expanded results to show per collapsed primary document. For instance, if you set this value to 3,
     * then at most 3 results per collapsed group will be displayed.
     * </p>
     * 
     * @return The number of expanded results to show per collapsed primary document. For instance, if you set this
     *         value to 3, then at most 3 results per collapsed group will be displayed.
     */
    public final Integer maxExpandedResultsPerItem() {
        return maxExpandedResultsPerItem;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxResultItemsToExpand());
        hashCode = 31 * hashCode + Objects.hashCode(maxExpandedResultsPerItem());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExpandConfiguration)) {
            return false;
        }
        ExpandConfiguration other = (ExpandConfiguration) obj;
        return Objects.equals(maxResultItemsToExpand(), other.maxResultItemsToExpand())
                && Objects.equals(maxExpandedResultsPerItem(), other.maxExpandedResultsPerItem());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExpandConfiguration").add("MaxResultItemsToExpand", maxResultItemsToExpand())
                .add("MaxExpandedResultsPerItem", maxExpandedResultsPerItem()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxResultItemsToExpand":
            return Optional.ofNullable(clazz.cast(maxResultItemsToExpand()));
        case "MaxExpandedResultsPerItem":
            return Optional.ofNullable(clazz.cast(maxExpandedResultsPerItem()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExpandConfiguration, T> g) {
        return obj -> g.apply((ExpandConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExpandConfiguration> {
        /**
         * <p>
         * The number of collapsed search result groups to expand. If you set this value to 10, for example, only the
         * first 10 out of 100 result groups will have expand functionality.
         * </p>
         * 
         * @param maxResultItemsToExpand
         *        The number of collapsed search result groups to expand. If you set this value to 10, for example, only
         *        the first 10 out of 100 result groups will have expand functionality.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResultItemsToExpand(Integer maxResultItemsToExpand);

        /**
         * <p>
         * The number of expanded results to show per collapsed primary document. For instance, if you set this value to
         * 3, then at most 3 results per collapsed group will be displayed.
         * </p>
         * 
         * @param maxExpandedResultsPerItem
         *        The number of expanded results to show per collapsed primary document. For instance, if you set this
         *        value to 3, then at most 3 results per collapsed group will be displayed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxExpandedResultsPerItem(Integer maxExpandedResultsPerItem);
    }

    static final class BuilderImpl implements Builder {
        private Integer maxResultItemsToExpand;

        private Integer maxExpandedResultsPerItem;

        private BuilderImpl() {
        }

        private BuilderImpl(ExpandConfiguration model) {
            maxResultItemsToExpand(model.maxResultItemsToExpand);
            maxExpandedResultsPerItem(model.maxExpandedResultsPerItem);
        }

        public final Integer getMaxResultItemsToExpand() {
            return maxResultItemsToExpand;
        }

        public final void setMaxResultItemsToExpand(Integer maxResultItemsToExpand) {
            this.maxResultItemsToExpand = maxResultItemsToExpand;
        }

        @Override
        public final Builder maxResultItemsToExpand(Integer maxResultItemsToExpand) {
            this.maxResultItemsToExpand = maxResultItemsToExpand;
            return this;
        }

        public final Integer getMaxExpandedResultsPerItem() {
            return maxExpandedResultsPerItem;
        }

        public final void setMaxExpandedResultsPerItem(Integer maxExpandedResultsPerItem) {
            this.maxExpandedResultsPerItem = maxExpandedResultsPerItem;
        }

        @Override
        public final Builder maxExpandedResultsPerItem(Integer maxExpandedResultsPerItem) {
            this.maxExpandedResultsPerItem = maxExpandedResultsPerItem;
            return this;
        }

        @Override
        public ExpandConfiguration build() {
            return new ExpandConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
