/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kendra.model.ConditionOperator;
import software.amazon.awssdk.services.kendra.model.DocumentAttributeValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DocumentAttributeCondition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DocumentAttributeCondition> {
    private static final SdkField<String> CONDITION_DOCUMENT_ATTRIBUTE_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConditionDocumentAttributeKey").getter(DocumentAttributeCondition.getter(DocumentAttributeCondition::conditionDocumentAttributeKey)).setter(DocumentAttributeCondition.setter(Builder::conditionDocumentAttributeKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConditionDocumentAttributeKey").build()}).build();
    private static final SdkField<String> OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Operator").getter(DocumentAttributeCondition.getter(DocumentAttributeCondition::operatorAsString)).setter(DocumentAttributeCondition.setter(Builder::operator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operator").build()}).build();
    private static final SdkField<DocumentAttributeValue> CONDITION_ON_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConditionOnValue").getter(DocumentAttributeCondition.getter(DocumentAttributeCondition::conditionOnValue)).setter(DocumentAttributeCondition.setter(Builder::conditionOnValue)).constructor(DocumentAttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConditionOnValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONDITION_DOCUMENT_ATTRIBUTE_KEY_FIELD, OPERATOR_FIELD, CONDITION_ON_VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String conditionDocumentAttributeKey;
    private final String operator;
    private final DocumentAttributeValue conditionOnValue;

    private DocumentAttributeCondition(BuilderImpl builder) {
        this.conditionDocumentAttributeKey = builder.conditionDocumentAttributeKey;
        this.operator = builder.operator;
        this.conditionOnValue = builder.conditionOnValue;
    }

    public final String conditionDocumentAttributeKey() {
        return this.conditionDocumentAttributeKey;
    }

    public final ConditionOperator operator() {
        return ConditionOperator.fromValue(this.operator);
    }

    public final String operatorAsString() {
        return this.operator;
    }

    public final DocumentAttributeValue conditionOnValue() {
        return this.conditionOnValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.conditionDocumentAttributeKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.operatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.conditionOnValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentAttributeCondition)) {
            return false;
        }
        DocumentAttributeCondition other = (DocumentAttributeCondition)obj;
        return Objects.equals(this.conditionDocumentAttributeKey(), other.conditionDocumentAttributeKey()) && Objects.equals(this.operatorAsString(), other.operatorAsString()) && Objects.equals(this.conditionOnValue(), other.conditionOnValue());
    }

    public final String toString() {
        return ToString.builder((String)"DocumentAttributeCondition").add("ConditionDocumentAttributeKey", (Object)this.conditionDocumentAttributeKey()).add("Operator", (Object)this.operatorAsString()).add("ConditionOnValue", (Object)this.conditionOnValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConditionDocumentAttributeKey": {
                return Optional.ofNullable(clazz.cast(this.conditionDocumentAttributeKey()));
            }
            case "Operator": {
                return Optional.ofNullable(clazz.cast(this.operatorAsString()));
            }
            case "ConditionOnValue": {
                return Optional.ofNullable(clazz.cast(this.conditionOnValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DocumentAttributeCondition, T> g) {
        return obj -> g.apply((DocumentAttributeCondition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String conditionDocumentAttributeKey;
        private String operator;
        private DocumentAttributeValue conditionOnValue;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentAttributeCondition model) {
            this.conditionDocumentAttributeKey(model.conditionDocumentAttributeKey);
            this.operator(model.operator);
            this.conditionOnValue(model.conditionOnValue);
        }

        public final String getConditionDocumentAttributeKey() {
            return this.conditionDocumentAttributeKey;
        }

        public final void setConditionDocumentAttributeKey(String conditionDocumentAttributeKey) {
            this.conditionDocumentAttributeKey = conditionDocumentAttributeKey;
        }

        @Override
        public final Builder conditionDocumentAttributeKey(String conditionDocumentAttributeKey) {
            this.conditionDocumentAttributeKey = conditionDocumentAttributeKey;
            return this;
        }

        public final String getOperator() {
            return this.operator;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public final Builder operator(ConditionOperator operator) {
            this.operator(operator == null ? null : operator.toString());
            return this;
        }

        public final DocumentAttributeValue.Builder getConditionOnValue() {
            return this.conditionOnValue != null ? this.conditionOnValue.toBuilder() : null;
        }

        public final void setConditionOnValue(DocumentAttributeValue.BuilderImpl conditionOnValue) {
            this.conditionOnValue = conditionOnValue != null ? conditionOnValue.build() : null;
        }

        @Override
        public final Builder conditionOnValue(DocumentAttributeValue conditionOnValue) {
            this.conditionOnValue = conditionOnValue;
            return this;
        }

        public DocumentAttributeCondition build() {
            return new DocumentAttributeCondition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DocumentAttributeCondition> {
        public Builder conditionDocumentAttributeKey(String var1);

        public Builder operator(String var1);

        public Builder operator(ConditionOperator var1);

        public Builder conditionOnValue(DocumentAttributeValue var1);

        default public Builder conditionOnValue(Consumer<DocumentAttributeValue.Builder> conditionOnValue) {
            return this.conditionOnValue((DocumentAttributeValue)((DocumentAttributeValue.Builder)DocumentAttributeValue.builder().applyMutation(conditionOnValue)).build());
        }
    }
}

