/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class SuggestionHighlightListCopier {
    static List<SuggestionHighlight> copy(Collection<? extends SuggestionHighlight> suggestionHighlightListParam) {
        List<SuggestionHighlight> list;
        if (suggestionHighlightListParam == null || suggestionHighlightListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<SuggestionHighlight> modifiableList = new ArrayList<>();
            suggestionHighlightListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<SuggestionHighlight> copyFromBuilder(
            Collection<? extends SuggestionHighlight.Builder> suggestionHighlightListParam) {
        List<SuggestionHighlight> list;
        if (suggestionHighlightListParam == null || suggestionHighlightListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<SuggestionHighlight> modifiableList = new ArrayList<>();
            suggestionHighlightListParam.forEach(entry -> {
                SuggestionHighlight member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<SuggestionHighlight.Builder> copyToBuilder(Collection<? extends SuggestionHighlight> suggestionHighlightListParam) {
        List<SuggestionHighlight.Builder> list;
        if (suggestionHighlightListParam == null || suggestionHighlightListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<SuggestionHighlight.Builder> modifiableList = new ArrayList<>();
            suggestionHighlightListParam.forEach(entry -> {
                SuggestionHighlight.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
