/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The facet values for the documents in the response.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FacetResult implements SdkPojo, Serializable, ToCopyableBuilder<FacetResult.Builder, FacetResult> {
    private static final SdkField<String> DOCUMENT_ATTRIBUTE_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentAttributeKey").getter(getter(FacetResult::documentAttributeKey))
            .setter(setter(Builder::documentAttributeKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentAttributeKey").build())
            .build();

    private static final SdkField<String> DOCUMENT_ATTRIBUTE_VALUE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DocumentAttributeValueType")
            .getter(getter(FacetResult::documentAttributeValueTypeAsString))
            .setter(setter(Builder::documentAttributeValueType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentAttributeValueType").build())
            .build();

    private static final SdkField<List<DocumentAttributeValueCountPair>> DOCUMENT_ATTRIBUTE_VALUE_COUNT_PAIRS_FIELD = SdkField
            .<List<DocumentAttributeValueCountPair>> builder(MarshallingType.LIST)
            .memberName("DocumentAttributeValueCountPairs")
            .getter(getter(FacetResult::documentAttributeValueCountPairs))
            .setter(setter(Builder::documentAttributeValueCountPairs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentAttributeValueCountPairs")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DocumentAttributeValueCountPair> builder(MarshallingType.SDK_POJO)
                                            .constructor(DocumentAttributeValueCountPair::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_ATTRIBUTE_KEY_FIELD,
            DOCUMENT_ATTRIBUTE_VALUE_TYPE_FIELD, DOCUMENT_ATTRIBUTE_VALUE_COUNT_PAIRS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String documentAttributeKey;

    private final String documentAttributeValueType;

    private final List<DocumentAttributeValueCountPair> documentAttributeValueCountPairs;

    private FacetResult(BuilderImpl builder) {
        this.documentAttributeKey = builder.documentAttributeKey;
        this.documentAttributeValueType = builder.documentAttributeValueType;
        this.documentAttributeValueCountPairs = builder.documentAttributeValueCountPairs;
    }

    /**
     * <p>
     * The key for the facet values. This is the same as the <code>DocumentAttributeKey</code> provided in the query.
     * </p>
     * 
     * @return The key for the facet values. This is the same as the <code>DocumentAttributeKey</code> provided in the
     *         query.
     */
    public final String documentAttributeKey() {
        return documentAttributeKey;
    }

    /**
     * <p>
     * The data type of the facet value. This is the same as the type defined for the index field when it was created.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #documentAttributeValueType} will return {@link DocumentAttributeValueType#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #documentAttributeValueTypeAsString}.
     * </p>
     * 
     * @return The data type of the facet value. This is the same as the type defined for the index field when it was
     *         created.
     * @see DocumentAttributeValueType
     */
    public final DocumentAttributeValueType documentAttributeValueType() {
        return DocumentAttributeValueType.fromValue(documentAttributeValueType);
    }

    /**
     * <p>
     * The data type of the facet value. This is the same as the type defined for the index field when it was created.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #documentAttributeValueType} will return {@link DocumentAttributeValueType#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #documentAttributeValueTypeAsString}.
     * </p>
     * 
     * @return The data type of the facet value. This is the same as the type defined for the index field when it was
     *         created.
     * @see DocumentAttributeValueType
     */
    public final String documentAttributeValueTypeAsString() {
        return documentAttributeValueType;
    }

    /**
     * For responses, this returns true if the service returned a value for the DocumentAttributeValueCountPairs
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasDocumentAttributeValueCountPairs() {
        return documentAttributeValueCountPairs != null && !(documentAttributeValueCountPairs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of key/value pairs, where the key is the value of the attribute and the count is the number of documents
     * that share the key value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDocumentAttributeValueCountPairs}
     * method.
     * </p>
     * 
     * @return An array of key/value pairs, where the key is the value of the attribute and the count is the number of
     *         documents that share the key value.
     */
    public final List<DocumentAttributeValueCountPair> documentAttributeValueCountPairs() {
        return documentAttributeValueCountPairs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(documentAttributeKey());
        hashCode = 31 * hashCode + Objects.hashCode(documentAttributeValueTypeAsString());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasDocumentAttributeValueCountPairs() ? documentAttributeValueCountPairs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FacetResult)) {
            return false;
        }
        FacetResult other = (FacetResult) obj;
        return Objects.equals(documentAttributeKey(), other.documentAttributeKey())
                && Objects.equals(documentAttributeValueTypeAsString(), other.documentAttributeValueTypeAsString())
                && hasDocumentAttributeValueCountPairs() == other.hasDocumentAttributeValueCountPairs()
                && Objects.equals(documentAttributeValueCountPairs(), other.documentAttributeValueCountPairs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("FacetResult")
                .add("DocumentAttributeKey", documentAttributeKey())
                .add("DocumentAttributeValueType", documentAttributeValueTypeAsString())
                .add("DocumentAttributeValueCountPairs",
                        hasDocumentAttributeValueCountPairs() ? documentAttributeValueCountPairs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DocumentAttributeKey":
            return Optional.ofNullable(clazz.cast(documentAttributeKey()));
        case "DocumentAttributeValueType":
            return Optional.ofNullable(clazz.cast(documentAttributeValueTypeAsString()));
        case "DocumentAttributeValueCountPairs":
            return Optional.ofNullable(clazz.cast(documentAttributeValueCountPairs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FacetResult, T> g) {
        return obj -> g.apply((FacetResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FacetResult> {
        /**
         * <p>
         * The key for the facet values. This is the same as the <code>DocumentAttributeKey</code> provided in the
         * query.
         * </p>
         * 
         * @param documentAttributeKey
         *        The key for the facet values. This is the same as the <code>DocumentAttributeKey</code> provided in
         *        the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentAttributeKey(String documentAttributeKey);

        /**
         * <p>
         * The data type of the facet value. This is the same as the type defined for the index field when it was
         * created.
         * </p>
         * 
         * @param documentAttributeValueType
         *        The data type of the facet value. This is the same as the type defined for the index field when it was
         *        created.
         * @see DocumentAttributeValueType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentAttributeValueType
         */
        Builder documentAttributeValueType(String documentAttributeValueType);

        /**
         * <p>
         * The data type of the facet value. This is the same as the type defined for the index field when it was
         * created.
         * </p>
         * 
         * @param documentAttributeValueType
         *        The data type of the facet value. This is the same as the type defined for the index field when it was
         *        created.
         * @see DocumentAttributeValueType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentAttributeValueType
         */
        Builder documentAttributeValueType(DocumentAttributeValueType documentAttributeValueType);

        /**
         * <p>
         * An array of key/value pairs, where the key is the value of the attribute and the count is the number of
         * documents that share the key value.
         * </p>
         * 
         * @param documentAttributeValueCountPairs
         *        An array of key/value pairs, where the key is the value of the attribute and the count is the number
         *        of documents that share the key value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentAttributeValueCountPairs(Collection<DocumentAttributeValueCountPair> documentAttributeValueCountPairs);

        /**
         * <p>
         * An array of key/value pairs, where the key is the value of the attribute and the count is the number of
         * documents that share the key value.
         * </p>
         * 
         * @param documentAttributeValueCountPairs
         *        An array of key/value pairs, where the key is the value of the attribute and the count is the number
         *        of documents that share the key value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentAttributeValueCountPairs(DocumentAttributeValueCountPair... documentAttributeValueCountPairs);

        /**
         * <p>
         * An array of key/value pairs, where the key is the value of the attribute and the count is the number of
         * documents that share the key value.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kendra.model.DocumentAttributeValueCountPair.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.kendra.model.DocumentAttributeValueCountPair#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kendra.model.DocumentAttributeValueCountPair.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #documentAttributeValueCountPairs(List<DocumentAttributeValueCountPair>)}.
         * 
         * @param documentAttributeValueCountPairs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kendra.model.DocumentAttributeValueCountPair.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documentAttributeValueCountPairs(java.util.Collection<DocumentAttributeValueCountPair>)
         */
        Builder documentAttributeValueCountPairs(
                Consumer<DocumentAttributeValueCountPair.Builder>... documentAttributeValueCountPairs);
    }

    static final class BuilderImpl implements Builder {
        private String documentAttributeKey;

        private String documentAttributeValueType;

        private List<DocumentAttributeValueCountPair> documentAttributeValueCountPairs = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FacetResult model) {
            documentAttributeKey(model.documentAttributeKey);
            documentAttributeValueType(model.documentAttributeValueType);
            documentAttributeValueCountPairs(model.documentAttributeValueCountPairs);
        }

        public final String getDocumentAttributeKey() {
            return documentAttributeKey;
        }

        public final void setDocumentAttributeKey(String documentAttributeKey) {
            this.documentAttributeKey = documentAttributeKey;
        }

        @Override
        public final Builder documentAttributeKey(String documentAttributeKey) {
            this.documentAttributeKey = documentAttributeKey;
            return this;
        }

        public final String getDocumentAttributeValueType() {
            return documentAttributeValueType;
        }

        public final void setDocumentAttributeValueType(String documentAttributeValueType) {
            this.documentAttributeValueType = documentAttributeValueType;
        }

        @Override
        public final Builder documentAttributeValueType(String documentAttributeValueType) {
            this.documentAttributeValueType = documentAttributeValueType;
            return this;
        }

        @Override
        public final Builder documentAttributeValueType(DocumentAttributeValueType documentAttributeValueType) {
            this.documentAttributeValueType(documentAttributeValueType == null ? null : documentAttributeValueType.toString());
            return this;
        }

        public final List<DocumentAttributeValueCountPair.Builder> getDocumentAttributeValueCountPairs() {
            List<DocumentAttributeValueCountPair.Builder> result = DocumentAttributeValueCountPairListCopier
                    .copyToBuilder(this.documentAttributeValueCountPairs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDocumentAttributeValueCountPairs(
                Collection<DocumentAttributeValueCountPair.BuilderImpl> documentAttributeValueCountPairs) {
            this.documentAttributeValueCountPairs = DocumentAttributeValueCountPairListCopier
                    .copyFromBuilder(documentAttributeValueCountPairs);
        }

        @Override
        public final Builder documentAttributeValueCountPairs(
                Collection<DocumentAttributeValueCountPair> documentAttributeValueCountPairs) {
            this.documentAttributeValueCountPairs = DocumentAttributeValueCountPairListCopier
                    .copy(documentAttributeValueCountPairs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentAttributeValueCountPairs(DocumentAttributeValueCountPair... documentAttributeValueCountPairs) {
            documentAttributeValueCountPairs(Arrays.asList(documentAttributeValueCountPairs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documentAttributeValueCountPairs(
                Consumer<DocumentAttributeValueCountPair.Builder>... documentAttributeValueCountPairs) {
            documentAttributeValueCountPairs(Stream.of(documentAttributeValueCountPairs)
                    .map(c -> DocumentAttributeValueCountPair.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public FacetResult build() {
            return new FacetResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
