/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the configuration information for a document field/attribute that you want to base query suggestions on.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SuggestableConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<SuggestableConfig.Builder, SuggestableConfig> {
    private static final SdkField<String> ATTRIBUTE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttributeName").getter(getter(SuggestableConfig::attributeName)).setter(setter(Builder::attributeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeName").build()).build();

    private static final SdkField<Boolean> SUGGESTABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Suggestable").getter(getter(SuggestableConfig::suggestable)).setter(setter(Builder::suggestable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Suggestable").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_NAME_FIELD,
            SUGGESTABLE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String attributeName;

    private final Boolean suggestable;

    private SuggestableConfig(BuilderImpl builder) {
        this.attributeName = builder.attributeName;
        this.suggestable = builder.suggestable;
    }

    /**
     * <p>
     * The name of the document field/attribute.
     * </p>
     * 
     * @return The name of the document field/attribute.
     */
    public final String attributeName() {
        return attributeName;
    }

    /**
     * <p>
     * <code>TRUE</code> means the document field/attribute is suggestible, so the contents within the field can be used
     * for query suggestions.
     * </p>
     * 
     * @return <code>TRUE</code> means the document field/attribute is suggestible, so the contents within the field can
     *         be used for query suggestions.
     */
    public final Boolean suggestable() {
        return suggestable;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributeName());
        hashCode = 31 * hashCode + Objects.hashCode(suggestable());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuggestableConfig)) {
            return false;
        }
        SuggestableConfig other = (SuggestableConfig) obj;
        return Objects.equals(attributeName(), other.attributeName()) && Objects.equals(suggestable(), other.suggestable());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SuggestableConfig").add("AttributeName", attributeName()).add("Suggestable", suggestable())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttributeName":
            return Optional.ofNullable(clazz.cast(attributeName()));
        case "Suggestable":
            return Optional.ofNullable(clazz.cast(suggestable()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SuggestableConfig, T> g) {
        return obj -> g.apply((SuggestableConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SuggestableConfig> {
        /**
         * <p>
         * The name of the document field/attribute.
         * </p>
         * 
         * @param attributeName
         *        The name of the document field/attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeName(String attributeName);

        /**
         * <p>
         * <code>TRUE</code> means the document field/attribute is suggestible, so the contents within the field can be
         * used for query suggestions.
         * </p>
         * 
         * @param suggestable
         *        <code>TRUE</code> means the document field/attribute is suggestible, so the contents within the field
         *        can be used for query suggestions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suggestable(Boolean suggestable);
    }

    static final class BuilderImpl implements Builder {
        private String attributeName;

        private Boolean suggestable;

        private BuilderImpl() {
        }

        private BuilderImpl(SuggestableConfig model) {
            attributeName(model.attributeName);
            suggestable(model.suggestable);
        }

        public final String getAttributeName() {
            return attributeName;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final Boolean getSuggestable() {
            return suggestable;
        }

        public final void setSuggestable(Boolean suggestable) {
            this.suggestable = suggestable;
        }

        @Override
        public final Builder suggestable(Boolean suggestable) {
            this.suggestable = suggestable;
            return this;
        }

        @Override
        public SuggestableConfig build() {
            return new SuggestableConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
