/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.kendra.DefaultKendraBaseClientBuilder;
import software.amazon.awssdk.services.kendra.DefaultKendraClient;
import software.amazon.awssdk.services.kendra.KendraClient;
import software.amazon.awssdk.services.kendra.KendraClientBuilder;
import software.amazon.awssdk.services.kendra.KendraServiceClientConfiguration;
import software.amazon.awssdk.services.kendra.endpoints.KendraEndpointProvider;

@SdkInternalApi
final class DefaultKendraClientBuilder
extends DefaultKendraBaseClientBuilder<KendraClientBuilder, KendraClient>
implements KendraClientBuilder {
    DefaultKendraClientBuilder() {
    }

    @Override
    public DefaultKendraClientBuilder endpointProvider(KendraEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final KendraClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultKendraClientBuilder.validateClientOptions(clientConfiguration);
        KendraServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultKendraClient client = new DefaultKendraClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private KendraServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return KendraServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

