/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.DataSourceInclusionsExclusionsStringsCopier;
import software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMapping;
import software.amazon.awssdk.services.kendra.model.DataSourceToIndexFieldMappingListCopier;
import software.amazon.awssdk.services.kendra.model.DataSourceVpcConfiguration;
import software.amazon.awssdk.services.kendra.model.IssueSubEntity;
import software.amazon.awssdk.services.kendra.model.IssueSubEntityFilterCopier;
import software.amazon.awssdk.services.kendra.model.IssueTypeCopier;
import software.amazon.awssdk.services.kendra.model.JiraStatusCopier;
import software.amazon.awssdk.services.kendra.model.ProjectCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JiraConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JiraConfiguration> {
    private static final SdkField<String> JIRA_ACCOUNT_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JiraAccountUrl").getter(JiraConfiguration.getter(JiraConfiguration::jiraAccountUrl)).setter(JiraConfiguration.setter(Builder::jiraAccountUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JiraAccountUrl").build()}).build();
    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecretArn").getter(JiraConfiguration.getter(JiraConfiguration::secretArn)).setter(JiraConfiguration.setter(Builder::secretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()}).build();
    private static final SdkField<Boolean> USE_CHANGE_LOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("UseChangeLog").getter(JiraConfiguration.getter(JiraConfiguration::useChangeLog)).setter(JiraConfiguration.setter(Builder::useChangeLog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseChangeLog").build()}).build();
    private static final SdkField<List<String>> PROJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Project").getter(JiraConfiguration.getter(JiraConfiguration::project)).setter(JiraConfiguration.setter(Builder::project)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Project").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ISSUE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IssueType").getter(JiraConfiguration.getter(JiraConfiguration::issueType)).setter(JiraConfiguration.setter(Builder::issueType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IssueType").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Status").getter(JiraConfiguration.getter(JiraConfiguration::status)).setter(JiraConfiguration.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ISSUE_SUB_ENTITY_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IssueSubEntityFilter").getter(JiraConfiguration.getter(JiraConfiguration::issueSubEntityFilterAsStrings)).setter(JiraConfiguration.setter(Builder::issueSubEntityFilterWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IssueSubEntityFilter").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DataSourceToIndexFieldMapping>> ATTACHMENT_FIELD_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AttachmentFieldMappings").getter(JiraConfiguration.getter(JiraConfiguration::attachmentFieldMappings)).setter(JiraConfiguration.setter(Builder::attachmentFieldMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentFieldMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSourceToIndexFieldMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DataSourceToIndexFieldMapping>> COMMENT_FIELD_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CommentFieldMappings").getter(JiraConfiguration.getter(JiraConfiguration::commentFieldMappings)).setter(JiraConfiguration.setter(Builder::commentFieldMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommentFieldMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSourceToIndexFieldMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DataSourceToIndexFieldMapping>> ISSUE_FIELD_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IssueFieldMappings").getter(JiraConfiguration.getter(JiraConfiguration::issueFieldMappings)).setter(JiraConfiguration.setter(Builder::issueFieldMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IssueFieldMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSourceToIndexFieldMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DataSourceToIndexFieldMapping>> PROJECT_FIELD_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProjectFieldMappings").getter(JiraConfiguration.getter(JiraConfiguration::projectFieldMappings)).setter(JiraConfiguration.setter(Builder::projectFieldMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectFieldMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSourceToIndexFieldMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<DataSourceToIndexFieldMapping>> WORK_LOG_FIELD_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("WorkLogFieldMappings").getter(JiraConfiguration.getter(JiraConfiguration::workLogFieldMappings)).setter(JiraConfiguration.setter(Builder::workLogFieldMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkLogFieldMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSourceToIndexFieldMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> INCLUSION_PATTERNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InclusionPatterns").getter(JiraConfiguration.getter(JiraConfiguration::inclusionPatterns)).setter(JiraConfiguration.setter(Builder::inclusionPatterns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InclusionPatterns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EXCLUSION_PATTERNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExclusionPatterns").getter(JiraConfiguration.getter(JiraConfiguration::exclusionPatterns)).setter(JiraConfiguration.setter(Builder::exclusionPatterns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusionPatterns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DataSourceVpcConfiguration> VPC_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcConfiguration").getter(JiraConfiguration.getter(JiraConfiguration::vpcConfiguration)).setter(JiraConfiguration.setter(Builder::vpcConfiguration)).constructor(DataSourceVpcConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JIRA_ACCOUNT_URL_FIELD, SECRET_ARN_FIELD, USE_CHANGE_LOG_FIELD, PROJECT_FIELD, ISSUE_TYPE_FIELD, STATUS_FIELD, ISSUE_SUB_ENTITY_FILTER_FIELD, ATTACHMENT_FIELD_MAPPINGS_FIELD, COMMENT_FIELD_MAPPINGS_FIELD, ISSUE_FIELD_MAPPINGS_FIELD, PROJECT_FIELD_MAPPINGS_FIELD, WORK_LOG_FIELD_MAPPINGS_FIELD, INCLUSION_PATTERNS_FIELD, EXCLUSION_PATTERNS_FIELD, VPC_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String jiraAccountUrl;
    private final String secretArn;
    private final Boolean useChangeLog;
    private final List<String> project;
    private final List<String> issueType;
    private final List<String> status;
    private final List<String> issueSubEntityFilter;
    private final List<DataSourceToIndexFieldMapping> attachmentFieldMappings;
    private final List<DataSourceToIndexFieldMapping> commentFieldMappings;
    private final List<DataSourceToIndexFieldMapping> issueFieldMappings;
    private final List<DataSourceToIndexFieldMapping> projectFieldMappings;
    private final List<DataSourceToIndexFieldMapping> workLogFieldMappings;
    private final List<String> inclusionPatterns;
    private final List<String> exclusionPatterns;
    private final DataSourceVpcConfiguration vpcConfiguration;

    private JiraConfiguration(BuilderImpl builder) {
        this.jiraAccountUrl = builder.jiraAccountUrl;
        this.secretArn = builder.secretArn;
        this.useChangeLog = builder.useChangeLog;
        this.project = builder.project;
        this.issueType = builder.issueType;
        this.status = builder.status;
        this.issueSubEntityFilter = builder.issueSubEntityFilter;
        this.attachmentFieldMappings = builder.attachmentFieldMappings;
        this.commentFieldMappings = builder.commentFieldMappings;
        this.issueFieldMappings = builder.issueFieldMappings;
        this.projectFieldMappings = builder.projectFieldMappings;
        this.workLogFieldMappings = builder.workLogFieldMappings;
        this.inclusionPatterns = builder.inclusionPatterns;
        this.exclusionPatterns = builder.exclusionPatterns;
        this.vpcConfiguration = builder.vpcConfiguration;
    }

    public final String jiraAccountUrl() {
        return this.jiraAccountUrl;
    }

    public final String secretArn() {
        return this.secretArn;
    }

    public final Boolean useChangeLog() {
        return this.useChangeLog;
    }

    public final boolean hasProject() {
        return this.project != null && !(this.project instanceof SdkAutoConstructList);
    }

    public final List<String> project() {
        return this.project;
    }

    public final boolean hasIssueType() {
        return this.issueType != null && !(this.issueType instanceof SdkAutoConstructList);
    }

    public final List<String> issueType() {
        return this.issueType;
    }

    public final boolean hasStatus() {
        return this.status != null && !(this.status instanceof SdkAutoConstructList);
    }

    public final List<String> status() {
        return this.status;
    }

    public final List<IssueSubEntity> issueSubEntityFilter() {
        return IssueSubEntityFilterCopier.copyStringToEnum(this.issueSubEntityFilter);
    }

    public final boolean hasIssueSubEntityFilter() {
        return this.issueSubEntityFilter != null && !(this.issueSubEntityFilter instanceof SdkAutoConstructList);
    }

    public final List<String> issueSubEntityFilterAsStrings() {
        return this.issueSubEntityFilter;
    }

    public final boolean hasAttachmentFieldMappings() {
        return this.attachmentFieldMappings != null && !(this.attachmentFieldMappings instanceof SdkAutoConstructList);
    }

    public final List<DataSourceToIndexFieldMapping> attachmentFieldMappings() {
        return this.attachmentFieldMappings;
    }

    public final boolean hasCommentFieldMappings() {
        return this.commentFieldMappings != null && !(this.commentFieldMappings instanceof SdkAutoConstructList);
    }

    public final List<DataSourceToIndexFieldMapping> commentFieldMappings() {
        return this.commentFieldMappings;
    }

    public final boolean hasIssueFieldMappings() {
        return this.issueFieldMappings != null && !(this.issueFieldMappings instanceof SdkAutoConstructList);
    }

    public final List<DataSourceToIndexFieldMapping> issueFieldMappings() {
        return this.issueFieldMappings;
    }

    public final boolean hasProjectFieldMappings() {
        return this.projectFieldMappings != null && !(this.projectFieldMappings instanceof SdkAutoConstructList);
    }

    public final List<DataSourceToIndexFieldMapping> projectFieldMappings() {
        return this.projectFieldMappings;
    }

    public final boolean hasWorkLogFieldMappings() {
        return this.workLogFieldMappings != null && !(this.workLogFieldMappings instanceof SdkAutoConstructList);
    }

    public final List<DataSourceToIndexFieldMapping> workLogFieldMappings() {
        return this.workLogFieldMappings;
    }

    public final boolean hasInclusionPatterns() {
        return this.inclusionPatterns != null && !(this.inclusionPatterns instanceof SdkAutoConstructList);
    }

    public final List<String> inclusionPatterns() {
        return this.inclusionPatterns;
    }

    public final boolean hasExclusionPatterns() {
        return this.exclusionPatterns != null && !(this.exclusionPatterns instanceof SdkAutoConstructList);
    }

    public final List<String> exclusionPatterns() {
        return this.exclusionPatterns;
    }

    public final DataSourceVpcConfiguration vpcConfiguration() {
        return this.vpcConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jiraAccountUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.useChangeLog());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProject() ? this.project() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIssueType() ? this.issueType() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatus() ? this.status() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIssueSubEntityFilter() ? this.issueSubEntityFilterAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttachmentFieldMappings() ? this.attachmentFieldMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCommentFieldMappings() ? this.commentFieldMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIssueFieldMappings() ? this.issueFieldMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProjectFieldMappings() ? this.projectFieldMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWorkLogFieldMappings() ? this.workLogFieldMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInclusionPatterns() ? this.inclusionPatterns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExclusionPatterns() ? this.exclusionPatterns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JiraConfiguration)) {
            return false;
        }
        JiraConfiguration other = (JiraConfiguration)obj;
        return Objects.equals(this.jiraAccountUrl(), other.jiraAccountUrl()) && Objects.equals(this.secretArn(), other.secretArn()) && Objects.equals(this.useChangeLog(), other.useChangeLog()) && this.hasProject() == other.hasProject() && Objects.equals(this.project(), other.project()) && this.hasIssueType() == other.hasIssueType() && Objects.equals(this.issueType(), other.issueType()) && this.hasStatus() == other.hasStatus() && Objects.equals(this.status(), other.status()) && this.hasIssueSubEntityFilter() == other.hasIssueSubEntityFilter() && Objects.equals(this.issueSubEntityFilterAsStrings(), other.issueSubEntityFilterAsStrings()) && this.hasAttachmentFieldMappings() == other.hasAttachmentFieldMappings() && Objects.equals(this.attachmentFieldMappings(), other.attachmentFieldMappings()) && this.hasCommentFieldMappings() == other.hasCommentFieldMappings() && Objects.equals(this.commentFieldMappings(), other.commentFieldMappings()) && this.hasIssueFieldMappings() == other.hasIssueFieldMappings() && Objects.equals(this.issueFieldMappings(), other.issueFieldMappings()) && this.hasProjectFieldMappings() == other.hasProjectFieldMappings() && Objects.equals(this.projectFieldMappings(), other.projectFieldMappings()) && this.hasWorkLogFieldMappings() == other.hasWorkLogFieldMappings() && Objects.equals(this.workLogFieldMappings(), other.workLogFieldMappings()) && this.hasInclusionPatterns() == other.hasInclusionPatterns() && Objects.equals(this.inclusionPatterns(), other.inclusionPatterns()) && this.hasExclusionPatterns() == other.hasExclusionPatterns() && Objects.equals(this.exclusionPatterns(), other.exclusionPatterns()) && Objects.equals(this.vpcConfiguration(), other.vpcConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"JiraConfiguration").add("JiraAccountUrl", (Object)this.jiraAccountUrl()).add("SecretArn", (Object)this.secretArn()).add("UseChangeLog", (Object)this.useChangeLog()).add("Project", this.hasProject() ? this.project() : null).add("IssueType", this.hasIssueType() ? this.issueType() : null).add("Status", this.hasStatus() ? this.status() : null).add("IssueSubEntityFilter", this.hasIssueSubEntityFilter() ? this.issueSubEntityFilterAsStrings() : null).add("AttachmentFieldMappings", this.hasAttachmentFieldMappings() ? this.attachmentFieldMappings() : null).add("CommentFieldMappings", this.hasCommentFieldMappings() ? this.commentFieldMappings() : null).add("IssueFieldMappings", this.hasIssueFieldMappings() ? this.issueFieldMappings() : null).add("ProjectFieldMappings", this.hasProjectFieldMappings() ? this.projectFieldMappings() : null).add("WorkLogFieldMappings", this.hasWorkLogFieldMappings() ? this.workLogFieldMappings() : null).add("InclusionPatterns", this.hasInclusionPatterns() ? this.inclusionPatterns() : null).add("ExclusionPatterns", this.hasExclusionPatterns() ? this.exclusionPatterns() : null).add("VpcConfiguration", (Object)this.vpcConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JiraAccountUrl": {
                return Optional.ofNullable(clazz.cast(this.jiraAccountUrl()));
            }
            case "SecretArn": {
                return Optional.ofNullable(clazz.cast(this.secretArn()));
            }
            case "UseChangeLog": {
                return Optional.ofNullable(clazz.cast(this.useChangeLog()));
            }
            case "Project": {
                return Optional.ofNullable(clazz.cast(this.project()));
            }
            case "IssueType": {
                return Optional.ofNullable(clazz.cast(this.issueType()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "IssueSubEntityFilter": {
                return Optional.ofNullable(clazz.cast(this.issueSubEntityFilterAsStrings()));
            }
            case "AttachmentFieldMappings": {
                return Optional.ofNullable(clazz.cast(this.attachmentFieldMappings()));
            }
            case "CommentFieldMappings": {
                return Optional.ofNullable(clazz.cast(this.commentFieldMappings()));
            }
            case "IssueFieldMappings": {
                return Optional.ofNullable(clazz.cast(this.issueFieldMappings()));
            }
            case "ProjectFieldMappings": {
                return Optional.ofNullable(clazz.cast(this.projectFieldMappings()));
            }
            case "WorkLogFieldMappings": {
                return Optional.ofNullable(clazz.cast(this.workLogFieldMappings()));
            }
            case "InclusionPatterns": {
                return Optional.ofNullable(clazz.cast(this.inclusionPatterns()));
            }
            case "ExclusionPatterns": {
                return Optional.ofNullable(clazz.cast(this.exclusionPatterns()));
            }
            case "VpcConfiguration": {
                return Optional.ofNullable(clazz.cast(this.vpcConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JiraConfiguration, T> g) {
        return obj -> g.apply((JiraConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jiraAccountUrl;
        private String secretArn;
        private Boolean useChangeLog;
        private List<String> project = DefaultSdkAutoConstructList.getInstance();
        private List<String> issueType = DefaultSdkAutoConstructList.getInstance();
        private List<String> status = DefaultSdkAutoConstructList.getInstance();
        private List<String> issueSubEntityFilter = DefaultSdkAutoConstructList.getInstance();
        private List<DataSourceToIndexFieldMapping> attachmentFieldMappings = DefaultSdkAutoConstructList.getInstance();
        private List<DataSourceToIndexFieldMapping> commentFieldMappings = DefaultSdkAutoConstructList.getInstance();
        private List<DataSourceToIndexFieldMapping> issueFieldMappings = DefaultSdkAutoConstructList.getInstance();
        private List<DataSourceToIndexFieldMapping> projectFieldMappings = DefaultSdkAutoConstructList.getInstance();
        private List<DataSourceToIndexFieldMapping> workLogFieldMappings = DefaultSdkAutoConstructList.getInstance();
        private List<String> inclusionPatterns = DefaultSdkAutoConstructList.getInstance();
        private List<String> exclusionPatterns = DefaultSdkAutoConstructList.getInstance();
        private DataSourceVpcConfiguration vpcConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(JiraConfiguration model) {
            this.jiraAccountUrl(model.jiraAccountUrl);
            this.secretArn(model.secretArn);
            this.useChangeLog(model.useChangeLog);
            this.project(model.project);
            this.issueType(model.issueType);
            this.status(model.status);
            this.issueSubEntityFilterWithStrings(model.issueSubEntityFilter);
            this.attachmentFieldMappings(model.attachmentFieldMappings);
            this.commentFieldMappings(model.commentFieldMappings);
            this.issueFieldMappings(model.issueFieldMappings);
            this.projectFieldMappings(model.projectFieldMappings);
            this.workLogFieldMappings(model.workLogFieldMappings);
            this.inclusionPatterns(model.inclusionPatterns);
            this.exclusionPatterns(model.exclusionPatterns);
            this.vpcConfiguration(model.vpcConfiguration);
        }

        public final String getJiraAccountUrl() {
            return this.jiraAccountUrl;
        }

        public final void setJiraAccountUrl(String jiraAccountUrl) {
            this.jiraAccountUrl = jiraAccountUrl;
        }

        @Override
        public final Builder jiraAccountUrl(String jiraAccountUrl) {
            this.jiraAccountUrl = jiraAccountUrl;
            return this;
        }

        public final String getSecretArn() {
            return this.secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final Boolean getUseChangeLog() {
            return this.useChangeLog;
        }

        public final void setUseChangeLog(Boolean useChangeLog) {
            this.useChangeLog = useChangeLog;
        }

        @Override
        public final Builder useChangeLog(Boolean useChangeLog) {
            this.useChangeLog = useChangeLog;
            return this;
        }

        public final Collection<String> getProject() {
            if (this.project instanceof SdkAutoConstructList) {
                return null;
            }
            return this.project;
        }

        public final void setProject(Collection<String> project) {
            this.project = ProjectCopier.copy(project);
        }

        @Override
        public final Builder project(Collection<String> project) {
            this.project = ProjectCopier.copy(project);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder project(String ... project) {
            this.project(Arrays.asList(project));
            return this;
        }

        public final Collection<String> getIssueType() {
            if (this.issueType instanceof SdkAutoConstructList) {
                return null;
            }
            return this.issueType;
        }

        public final void setIssueType(Collection<String> issueType) {
            this.issueType = IssueTypeCopier.copy(issueType);
        }

        @Override
        public final Builder issueType(Collection<String> issueType) {
            this.issueType = IssueTypeCopier.copy(issueType);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder issueType(String ... issueType) {
            this.issueType(Arrays.asList(issueType));
            return this;
        }

        public final Collection<String> getStatus() {
            if (this.status instanceof SdkAutoConstructList) {
                return null;
            }
            return this.status;
        }

        public final void setStatus(Collection<String> status) {
            this.status = JiraStatusCopier.copy(status);
        }

        @Override
        public final Builder status(Collection<String> status) {
            this.status = JiraStatusCopier.copy(status);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder status(String ... status) {
            this.status(Arrays.asList(status));
            return this;
        }

        public final Collection<String> getIssueSubEntityFilter() {
            if (this.issueSubEntityFilter instanceof SdkAutoConstructList) {
                return null;
            }
            return this.issueSubEntityFilter;
        }

        public final void setIssueSubEntityFilter(Collection<String> issueSubEntityFilter) {
            this.issueSubEntityFilter = IssueSubEntityFilterCopier.copy(issueSubEntityFilter);
        }

        @Override
        public final Builder issueSubEntityFilterWithStrings(Collection<String> issueSubEntityFilter) {
            this.issueSubEntityFilter = IssueSubEntityFilterCopier.copy(issueSubEntityFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder issueSubEntityFilterWithStrings(String ... issueSubEntityFilter) {
            this.issueSubEntityFilterWithStrings(Arrays.asList(issueSubEntityFilter));
            return this;
        }

        @Override
        public final Builder issueSubEntityFilter(Collection<IssueSubEntity> issueSubEntityFilter) {
            this.issueSubEntityFilter = IssueSubEntityFilterCopier.copyEnumToString(issueSubEntityFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder issueSubEntityFilter(IssueSubEntity ... issueSubEntityFilter) {
            this.issueSubEntityFilter(Arrays.asList(issueSubEntityFilter));
            return this;
        }

        public final List<DataSourceToIndexFieldMapping.Builder> getAttachmentFieldMappings() {
            List<DataSourceToIndexFieldMapping.Builder> result = DataSourceToIndexFieldMappingListCopier.copyToBuilder(this.attachmentFieldMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttachmentFieldMappings(Collection<DataSourceToIndexFieldMapping.BuilderImpl> attachmentFieldMappings) {
            this.attachmentFieldMappings = DataSourceToIndexFieldMappingListCopier.copyFromBuilder(attachmentFieldMappings);
        }

        @Override
        public final Builder attachmentFieldMappings(Collection<DataSourceToIndexFieldMapping> attachmentFieldMappings) {
            this.attachmentFieldMappings = DataSourceToIndexFieldMappingListCopier.copy(attachmentFieldMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachmentFieldMappings(DataSourceToIndexFieldMapping ... attachmentFieldMappings) {
            this.attachmentFieldMappings(Arrays.asList(attachmentFieldMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachmentFieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... attachmentFieldMappings) {
            this.attachmentFieldMappings(Stream.of(attachmentFieldMappings).map(c -> (DataSourceToIndexFieldMapping)((DataSourceToIndexFieldMapping.Builder)DataSourceToIndexFieldMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DataSourceToIndexFieldMapping.Builder> getCommentFieldMappings() {
            List<DataSourceToIndexFieldMapping.Builder> result = DataSourceToIndexFieldMappingListCopier.copyToBuilder(this.commentFieldMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCommentFieldMappings(Collection<DataSourceToIndexFieldMapping.BuilderImpl> commentFieldMappings) {
            this.commentFieldMappings = DataSourceToIndexFieldMappingListCopier.copyFromBuilder(commentFieldMappings);
        }

        @Override
        public final Builder commentFieldMappings(Collection<DataSourceToIndexFieldMapping> commentFieldMappings) {
            this.commentFieldMappings = DataSourceToIndexFieldMappingListCopier.copy(commentFieldMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commentFieldMappings(DataSourceToIndexFieldMapping ... commentFieldMappings) {
            this.commentFieldMappings(Arrays.asList(commentFieldMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commentFieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... commentFieldMappings) {
            this.commentFieldMappings(Stream.of(commentFieldMappings).map(c -> (DataSourceToIndexFieldMapping)((DataSourceToIndexFieldMapping.Builder)DataSourceToIndexFieldMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DataSourceToIndexFieldMapping.Builder> getIssueFieldMappings() {
            List<DataSourceToIndexFieldMapping.Builder> result = DataSourceToIndexFieldMappingListCopier.copyToBuilder(this.issueFieldMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIssueFieldMappings(Collection<DataSourceToIndexFieldMapping.BuilderImpl> issueFieldMappings) {
            this.issueFieldMappings = DataSourceToIndexFieldMappingListCopier.copyFromBuilder(issueFieldMappings);
        }

        @Override
        public final Builder issueFieldMappings(Collection<DataSourceToIndexFieldMapping> issueFieldMappings) {
            this.issueFieldMappings = DataSourceToIndexFieldMappingListCopier.copy(issueFieldMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder issueFieldMappings(DataSourceToIndexFieldMapping ... issueFieldMappings) {
            this.issueFieldMappings(Arrays.asList(issueFieldMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder issueFieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... issueFieldMappings) {
            this.issueFieldMappings(Stream.of(issueFieldMappings).map(c -> (DataSourceToIndexFieldMapping)((DataSourceToIndexFieldMapping.Builder)DataSourceToIndexFieldMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DataSourceToIndexFieldMapping.Builder> getProjectFieldMappings() {
            List<DataSourceToIndexFieldMapping.Builder> result = DataSourceToIndexFieldMappingListCopier.copyToBuilder(this.projectFieldMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProjectFieldMappings(Collection<DataSourceToIndexFieldMapping.BuilderImpl> projectFieldMappings) {
            this.projectFieldMappings = DataSourceToIndexFieldMappingListCopier.copyFromBuilder(projectFieldMappings);
        }

        @Override
        public final Builder projectFieldMappings(Collection<DataSourceToIndexFieldMapping> projectFieldMappings) {
            this.projectFieldMappings = DataSourceToIndexFieldMappingListCopier.copy(projectFieldMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projectFieldMappings(DataSourceToIndexFieldMapping ... projectFieldMappings) {
            this.projectFieldMappings(Arrays.asList(projectFieldMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projectFieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... projectFieldMappings) {
            this.projectFieldMappings(Stream.of(projectFieldMappings).map(c -> (DataSourceToIndexFieldMapping)((DataSourceToIndexFieldMapping.Builder)DataSourceToIndexFieldMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<DataSourceToIndexFieldMapping.Builder> getWorkLogFieldMappings() {
            List<DataSourceToIndexFieldMapping.Builder> result = DataSourceToIndexFieldMappingListCopier.copyToBuilder(this.workLogFieldMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWorkLogFieldMappings(Collection<DataSourceToIndexFieldMapping.BuilderImpl> workLogFieldMappings) {
            this.workLogFieldMappings = DataSourceToIndexFieldMappingListCopier.copyFromBuilder(workLogFieldMappings);
        }

        @Override
        public final Builder workLogFieldMappings(Collection<DataSourceToIndexFieldMapping> workLogFieldMappings) {
            this.workLogFieldMappings = DataSourceToIndexFieldMappingListCopier.copy(workLogFieldMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workLogFieldMappings(DataSourceToIndexFieldMapping ... workLogFieldMappings) {
            this.workLogFieldMappings(Arrays.asList(workLogFieldMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workLogFieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... workLogFieldMappings) {
            this.workLogFieldMappings(Stream.of(workLogFieldMappings).map(c -> (DataSourceToIndexFieldMapping)((DataSourceToIndexFieldMapping.Builder)DataSourceToIndexFieldMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getInclusionPatterns() {
            if (this.inclusionPatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inclusionPatterns;
        }

        public final void setInclusionPatterns(Collection<String> inclusionPatterns) {
            this.inclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(inclusionPatterns);
        }

        @Override
        public final Builder inclusionPatterns(Collection<String> inclusionPatterns) {
            this.inclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(inclusionPatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inclusionPatterns(String ... inclusionPatterns) {
            this.inclusionPatterns(Arrays.asList(inclusionPatterns));
            return this;
        }

        public final Collection<String> getExclusionPatterns() {
            if (this.exclusionPatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.exclusionPatterns;
        }

        public final void setExclusionPatterns(Collection<String> exclusionPatterns) {
            this.exclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(exclusionPatterns);
        }

        @Override
        public final Builder exclusionPatterns(Collection<String> exclusionPatterns) {
            this.exclusionPatterns = DataSourceInclusionsExclusionsStringsCopier.copy(exclusionPatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exclusionPatterns(String ... exclusionPatterns) {
            this.exclusionPatterns(Arrays.asList(exclusionPatterns));
            return this;
        }

        public final DataSourceVpcConfiguration.Builder getVpcConfiguration() {
            return this.vpcConfiguration != null ? this.vpcConfiguration.toBuilder() : null;
        }

        public final void setVpcConfiguration(DataSourceVpcConfiguration.BuilderImpl vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration != null ? vpcConfiguration.build() : null;
        }

        @Override
        public final Builder vpcConfiguration(DataSourceVpcConfiguration vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        public JiraConfiguration build() {
            return new JiraConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JiraConfiguration> {
        public Builder jiraAccountUrl(String var1);

        public Builder secretArn(String var1);

        public Builder useChangeLog(Boolean var1);

        public Builder project(Collection<String> var1);

        public Builder project(String ... var1);

        public Builder issueType(Collection<String> var1);

        public Builder issueType(String ... var1);

        public Builder status(Collection<String> var1);

        public Builder status(String ... var1);

        public Builder issueSubEntityFilterWithStrings(Collection<String> var1);

        public Builder issueSubEntityFilterWithStrings(String ... var1);

        public Builder issueSubEntityFilter(Collection<IssueSubEntity> var1);

        public Builder issueSubEntityFilter(IssueSubEntity ... var1);

        public Builder attachmentFieldMappings(Collection<DataSourceToIndexFieldMapping> var1);

        public Builder attachmentFieldMappings(DataSourceToIndexFieldMapping ... var1);

        public Builder attachmentFieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... var1);

        public Builder commentFieldMappings(Collection<DataSourceToIndexFieldMapping> var1);

        public Builder commentFieldMappings(DataSourceToIndexFieldMapping ... var1);

        public Builder commentFieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... var1);

        public Builder issueFieldMappings(Collection<DataSourceToIndexFieldMapping> var1);

        public Builder issueFieldMappings(DataSourceToIndexFieldMapping ... var1);

        public Builder issueFieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... var1);

        public Builder projectFieldMappings(Collection<DataSourceToIndexFieldMapping> var1);

        public Builder projectFieldMappings(DataSourceToIndexFieldMapping ... var1);

        public Builder projectFieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... var1);

        public Builder workLogFieldMappings(Collection<DataSourceToIndexFieldMapping> var1);

        public Builder workLogFieldMappings(DataSourceToIndexFieldMapping ... var1);

        public Builder workLogFieldMappings(Consumer<DataSourceToIndexFieldMapping.Builder> ... var1);

        public Builder inclusionPatterns(Collection<String> var1);

        public Builder inclusionPatterns(String ... var1);

        public Builder exclusionPatterns(Collection<String> var1);

        public Builder exclusionPatterns(String ... var1);

        public Builder vpcConfiguration(DataSourceVpcConfiguration var1);

        default public Builder vpcConfiguration(Consumer<DataSourceVpcConfiguration.Builder> vpcConfiguration) {
            return this.vpcConfiguration((DataSourceVpcConfiguration)((DataSourceVpcConfiguration.Builder)DataSourceVpcConfiguration.builder().applyMutation(vpcConfiguration)).build());
        }
    }
}

