/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kendra.model.KendraResponse;
import software.amazon.awssdk.services.kendra.model.Suggestion;
import software.amazon.awssdk.services.kendra.model.SuggestionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetQuerySuggestionsResponse
extends KendraResponse
implements ToCopyableBuilder<Builder, GetQuerySuggestionsResponse> {
    private static final SdkField<String> QUERY_SUGGESTIONS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QuerySuggestionsId").getter(GetQuerySuggestionsResponse.getter(GetQuerySuggestionsResponse::querySuggestionsId)).setter(GetQuerySuggestionsResponse.setter(Builder::querySuggestionsId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuerySuggestionsId").build()}).build();
    private static final SdkField<List<Suggestion>> SUGGESTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Suggestions").getter(GetQuerySuggestionsResponse.getter(GetQuerySuggestionsResponse::suggestions)).setter(GetQuerySuggestionsResponse.setter(Builder::suggestions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Suggestions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Suggestion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_SUGGESTIONS_ID_FIELD, SUGGESTIONS_FIELD));
    private final String querySuggestionsId;
    private final List<Suggestion> suggestions;

    private GetQuerySuggestionsResponse(BuilderImpl builder) {
        super(builder);
        this.querySuggestionsId = builder.querySuggestionsId;
        this.suggestions = builder.suggestions;
    }

    public final String querySuggestionsId() {
        return this.querySuggestionsId;
    }

    public final boolean hasSuggestions() {
        return this.suggestions != null && !(this.suggestions instanceof SdkAutoConstructList);
    }

    public final List<Suggestion> suggestions() {
        return this.suggestions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.querySuggestionsId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuggestions() ? this.suggestions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetQuerySuggestionsResponse)) {
            return false;
        }
        GetQuerySuggestionsResponse other = (GetQuerySuggestionsResponse)((Object)obj);
        return Objects.equals(this.querySuggestionsId(), other.querySuggestionsId()) && this.hasSuggestions() == other.hasSuggestions() && Objects.equals(this.suggestions(), other.suggestions());
    }

    public final String toString() {
        return ToString.builder((String)"GetQuerySuggestionsResponse").add("QuerySuggestionsId", (Object)this.querySuggestionsId()).add("Suggestions", this.hasSuggestions() ? this.suggestions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QuerySuggestionsId": {
                return Optional.ofNullable(clazz.cast(this.querySuggestionsId()));
            }
            case "Suggestions": {
                return Optional.ofNullable(clazz.cast(this.suggestions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetQuerySuggestionsResponse, T> g) {
        return obj -> g.apply((GetQuerySuggestionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KendraResponse.BuilderImpl
    implements Builder {
        private String querySuggestionsId;
        private List<Suggestion> suggestions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetQuerySuggestionsResponse model) {
            super(model);
            this.querySuggestionsId(model.querySuggestionsId);
            this.suggestions(model.suggestions);
        }

        public final String getQuerySuggestionsId() {
            return this.querySuggestionsId;
        }

        public final void setQuerySuggestionsId(String querySuggestionsId) {
            this.querySuggestionsId = querySuggestionsId;
        }

        @Override
        public final Builder querySuggestionsId(String querySuggestionsId) {
            this.querySuggestionsId = querySuggestionsId;
            return this;
        }

        public final List<Suggestion.Builder> getSuggestions() {
            List<Suggestion.Builder> result = SuggestionListCopier.copyToBuilder(this.suggestions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuggestions(Collection<Suggestion.BuilderImpl> suggestions) {
            this.suggestions = SuggestionListCopier.copyFromBuilder(suggestions);
        }

        @Override
        public final Builder suggestions(Collection<Suggestion> suggestions) {
            this.suggestions = SuggestionListCopier.copy(suggestions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suggestions(Suggestion ... suggestions) {
            this.suggestions(Arrays.asList(suggestions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suggestions(Consumer<Suggestion.Builder> ... suggestions) {
            this.suggestions(Stream.of(suggestions).map(c -> (Suggestion)((Suggestion.Builder)Suggestion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetQuerySuggestionsResponse build() {
            return new GetQuerySuggestionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KendraResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetQuerySuggestionsResponse> {
        public Builder querySuggestionsId(String var1);

        public Builder suggestions(Collection<Suggestion> var1);

        public Builder suggestions(Suggestion ... var1);

        public Builder suggestions(Consumer<Suggestion.Builder> ... var1);
    }
}

