/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum WarningCode {
    QUERY_LANGUAGE_INVALID_SYNTAX("QUERY_LANGUAGE_INVALID_SYNTAX"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, WarningCode> VALUE_MAP;
    private final String value;

    private WarningCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WarningCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<WarningCode> knownValues() {
        EnumSet<WarningCode> knownValues = EnumSet.allOf(WarningCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(WarningCode.class, WarningCode::toString);
    }
}

