/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kendra.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kendra.KendraAsyncClient;
import software.amazon.awssdk.services.kendra.model.ListThesauriRequest;
import software.amazon.awssdk.services.kendra.model.ListThesauriResponse;

public class ListThesauriPublisher
implements SdkPublisher<ListThesauriResponse> {
    private final KendraAsyncClient client;
    private final ListThesauriRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListThesauriPublisher(KendraAsyncClient client, ListThesauriRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListThesauriPublisher(KendraAsyncClient client, ListThesauriRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListThesauriResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListThesauriResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListThesauriResponseFetcher
    implements AsyncPageFetcher<ListThesauriResponse> {
        private ListThesauriResponseFetcher() {
        }

        public boolean hasNextPage(ListThesauriResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListThesauriResponse> nextPage(ListThesauriResponse previousPage) {
            if (previousPage == null) {
                return ListThesauriPublisher.this.client.listThesauri(ListThesauriPublisher.this.firstRequest);
            }
            return ListThesauriPublisher.this.client.listThesauri((ListThesauriRequest)((Object)ListThesauriPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

