/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafkaconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListWorkerConfigurationsResponse extends KafkaConnectResponse implements
        ToCopyableBuilder<ListWorkerConfigurationsResponse.Builder, ListWorkerConfigurationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListWorkerConfigurationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<WorkerConfigurationSummary>> WORKER_CONFIGURATIONS_FIELD = SdkField
            .<List<WorkerConfigurationSummary>> builder(MarshallingType.LIST)
            .memberName("workerConfigurations")
            .getter(getter(ListWorkerConfigurationsResponse::workerConfigurations))
            .setter(setter(Builder::workerConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workerConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WorkerConfigurationSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(WorkerConfigurationSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            WORKER_CONFIGURATIONS_FIELD));

    private final String nextToken;

    private final List<WorkerConfigurationSummary> workerConfigurations;

    private ListWorkerConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.workerConfigurations = builder.workerConfigurations;
    }

    /**
     * <p>
     * If the response of a ListWorkerConfigurations operation is truncated, it will include a NextToken. Send this
     * NextToken in a subsequent request to continue listing from where the previous operation left off.
     * </p>
     * 
     * @return If the response of a ListWorkerConfigurations operation is truncated, it will include a NextToken. Send
     *         this NextToken in a subsequent request to continue listing from where the previous operation left off.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the WorkerConfigurations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasWorkerConfigurations() {
        return workerConfigurations != null && !(workerConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of worker configuration descriptions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWorkerConfigurations} method.
     * </p>
     * 
     * @return An array of worker configuration descriptions.
     */
    public final List<WorkerConfigurationSummary> workerConfigurations() {
        return workerConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasWorkerConfigurations() ? workerConfigurations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkerConfigurationsResponse)) {
            return false;
        }
        ListWorkerConfigurationsResponse other = (ListWorkerConfigurationsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasWorkerConfigurations() == other.hasWorkerConfigurations()
                && Objects.equals(workerConfigurations(), other.workerConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListWorkerConfigurationsResponse").add("NextToken", nextToken())
                .add("WorkerConfigurations", hasWorkerConfigurations() ? workerConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "workerConfigurations":
            return Optional.ofNullable(clazz.cast(workerConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListWorkerConfigurationsResponse, T> g) {
        return obj -> g.apply((ListWorkerConfigurationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KafkaConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListWorkerConfigurationsResponse> {
        /**
         * <p>
         * If the response of a ListWorkerConfigurations operation is truncated, it will include a NextToken. Send this
         * NextToken in a subsequent request to continue listing from where the previous operation left off.
         * </p>
         * 
         * @param nextToken
         *        If the response of a ListWorkerConfigurations operation is truncated, it will include a NextToken.
         *        Send this NextToken in a subsequent request to continue listing from where the previous operation left
         *        off.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An array of worker configuration descriptions.
         * </p>
         * 
         * @param workerConfigurations
         *        An array of worker configuration descriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workerConfigurations(Collection<WorkerConfigurationSummary> workerConfigurations);

        /**
         * <p>
         * An array of worker configuration descriptions.
         * </p>
         * 
         * @param workerConfigurations
         *        An array of worker configuration descriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workerConfigurations(WorkerConfigurationSummary... workerConfigurations);

        /**
         * <p>
         * An array of worker configuration descriptions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kafkaconnect.model.WorkerConfigurationSummary.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.kafkaconnect.model.WorkerConfigurationSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kafkaconnect.model.WorkerConfigurationSummary.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #workerConfigurations(List<WorkerConfigurationSummary>)}.
         * 
         * @param workerConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kafkaconnect.model.WorkerConfigurationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workerConfigurations(java.util.Collection<WorkerConfigurationSummary>)
         */
        Builder workerConfigurations(Consumer<WorkerConfigurationSummary.Builder>... workerConfigurations);
    }

    static final class BuilderImpl extends KafkaConnectResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<WorkerConfigurationSummary> workerConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorkerConfigurationsResponse model) {
            super(model);
            nextToken(model.nextToken);
            workerConfigurations(model.workerConfigurations);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<WorkerConfigurationSummary.Builder> getWorkerConfigurations() {
            List<WorkerConfigurationSummary.Builder> result = ___listOfWorkerConfigurationSummaryCopier
                    .copyToBuilder(this.workerConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWorkerConfigurations(Collection<WorkerConfigurationSummary.BuilderImpl> workerConfigurations) {
            this.workerConfigurations = ___listOfWorkerConfigurationSummaryCopier.copyFromBuilder(workerConfigurations);
        }

        @Override
        public final Builder workerConfigurations(Collection<WorkerConfigurationSummary> workerConfigurations) {
            this.workerConfigurations = ___listOfWorkerConfigurationSummaryCopier.copy(workerConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workerConfigurations(WorkerConfigurationSummary... workerConfigurations) {
            workerConfigurations(Arrays.asList(workerConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workerConfigurations(Consumer<WorkerConfigurationSummary.Builder>... workerConfigurations) {
            workerConfigurations(Stream.of(workerConfigurations)
                    .map(c -> WorkerConfigurationSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListWorkerConfigurationsResponse build() {
            return new ListWorkerConfigurationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
