/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafkaconnect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum CustomPluginState {
    CREATING("CREATING"),

    CREATE_FAILED("CREATE_FAILED"),

    ACTIVE("ACTIVE"),

    UPDATING("UPDATING"),

    UPDATE_FAILED("UPDATE_FAILED"),

    DELETING("DELETING"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CustomPluginState> VALUE_MAP = EnumUtils.uniqueIndex(CustomPluginState.class,
            CustomPluginState::toString);

    private final String value;

    private CustomPluginState(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return CustomPluginState corresponding to the value
     */
    public static CustomPluginState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link CustomPluginState}s
     */
    public static Set<CustomPluginState> knownValues() {
        Set<CustomPluginState> knownValues = EnumSet.allOf(CustomPluginState.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
