/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafkaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A description of the connector's capacity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CapacityDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<CapacityDescription.Builder, CapacityDescription> {
    private static final SdkField<AutoScalingDescription> AUTO_SCALING_FIELD = SdkField
            .<AutoScalingDescription> builder(MarshallingType.SDK_POJO).memberName("autoScaling")
            .getter(getter(CapacityDescription::autoScaling)).setter(setter(Builder::autoScaling))
            .constructor(AutoScalingDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoScaling").build()).build();

    private static final SdkField<ProvisionedCapacityDescription> PROVISIONED_CAPACITY_FIELD = SdkField
            .<ProvisionedCapacityDescription> builder(MarshallingType.SDK_POJO).memberName("provisionedCapacity")
            .getter(getter(CapacityDescription::provisionedCapacity)).setter(setter(Builder::provisionedCapacity))
            .constructor(ProvisionedCapacityDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisionedCapacity").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_FIELD,
            PROVISIONED_CAPACITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final AutoScalingDescription autoScaling;

    private final ProvisionedCapacityDescription provisionedCapacity;

    private CapacityDescription(BuilderImpl builder) {
        this.autoScaling = builder.autoScaling;
        this.provisionedCapacity = builder.provisionedCapacity;
    }

    /**
     * <p>
     * Describes the connector's auto scaling capacity.
     * </p>
     * 
     * @return Describes the connector's auto scaling capacity.
     */
    public final AutoScalingDescription autoScaling() {
        return autoScaling;
    }

    /**
     * <p>
     * Describes a connector's provisioned capacity.
     * </p>
     * 
     * @return Describes a connector's provisioned capacity.
     */
    public final ProvisionedCapacityDescription provisionedCapacity() {
        return provisionedCapacity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(autoScaling());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedCapacity());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityDescription)) {
            return false;
        }
        CapacityDescription other = (CapacityDescription) obj;
        return Objects.equals(autoScaling(), other.autoScaling())
                && Objects.equals(provisionedCapacity(), other.provisionedCapacity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CapacityDescription").add("AutoScaling", autoScaling())
                .add("ProvisionedCapacity", provisionedCapacity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "autoScaling":
            return Optional.ofNullable(clazz.cast(autoScaling()));
        case "provisionedCapacity":
            return Optional.ofNullable(clazz.cast(provisionedCapacity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CapacityDescription, T> g) {
        return obj -> g.apply((CapacityDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CapacityDescription> {
        /**
         * <p>
         * Describes the connector's auto scaling capacity.
         * </p>
         * 
         * @param autoScaling
         *        Describes the connector's auto scaling capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScaling(AutoScalingDescription autoScaling);

        /**
         * <p>
         * Describes the connector's auto scaling capacity.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutoScalingDescription.Builder} avoiding
         * the need to create one manually via {@link AutoScalingDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoScalingDescription.Builder#build()} is called immediately and
         * its result is passed to {@link #autoScaling(AutoScalingDescription)}.
         * 
         * @param autoScaling
         *        a consumer that will call methods on {@link AutoScalingDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoScaling(AutoScalingDescription)
         */
        default Builder autoScaling(Consumer<AutoScalingDescription.Builder> autoScaling) {
            return autoScaling(AutoScalingDescription.builder().applyMutation(autoScaling).build());
        }

        /**
         * <p>
         * Describes a connector's provisioned capacity.
         * </p>
         * 
         * @param provisionedCapacity
         *        Describes a connector's provisioned capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedCapacity(ProvisionedCapacityDescription provisionedCapacity);

        /**
         * <p>
         * Describes a connector's provisioned capacity.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProvisionedCapacityDescription.Builder}
         * avoiding the need to create one manually via {@link ProvisionedCapacityDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProvisionedCapacityDescription.Builder#build()} is called
         * immediately and its result is passed to {@link #provisionedCapacity(ProvisionedCapacityDescription)}.
         * 
         * @param provisionedCapacity
         *        a consumer that will call methods on {@link ProvisionedCapacityDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #provisionedCapacity(ProvisionedCapacityDescription)
         */
        default Builder provisionedCapacity(Consumer<ProvisionedCapacityDescription.Builder> provisionedCapacity) {
            return provisionedCapacity(ProvisionedCapacityDescription.builder().applyMutation(provisionedCapacity).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AutoScalingDescription autoScaling;

        private ProvisionedCapacityDescription provisionedCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityDescription model) {
            autoScaling(model.autoScaling);
            provisionedCapacity(model.provisionedCapacity);
        }

        public final AutoScalingDescription.Builder getAutoScaling() {
            return autoScaling != null ? autoScaling.toBuilder() : null;
        }

        public final void setAutoScaling(AutoScalingDescription.BuilderImpl autoScaling) {
            this.autoScaling = autoScaling != null ? autoScaling.build() : null;
        }

        @Override
        public final Builder autoScaling(AutoScalingDescription autoScaling) {
            this.autoScaling = autoScaling;
            return this;
        }

        public final ProvisionedCapacityDescription.Builder getProvisionedCapacity() {
            return provisionedCapacity != null ? provisionedCapacity.toBuilder() : null;
        }

        public final void setProvisionedCapacity(ProvisionedCapacityDescription.BuilderImpl provisionedCapacity) {
            this.provisionedCapacity = provisionedCapacity != null ? provisionedCapacity.build() : null;
        }

        @Override
        public final Builder provisionedCapacity(ProvisionedCapacityDescription provisionedCapacity) {
            this.provisionedCapacity = provisionedCapacity;
            return this;
        }

        @Override
        public CapacityDescription build() {
            return new CapacityDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
