/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class Firehose implements SdkPojo, Serializable, ToCopyableBuilder<Firehose.Builder, Firehose> {
    private static final SdkField<String> DELIVERY_STREAM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeliveryStream").getter(getter(Firehose::deliveryStream)).setter(setter(Builder::deliveryStream))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deliveryStream").build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled").getter(getter(Firehose::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIVERY_STREAM_FIELD,
            ENABLED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String deliveryStream;

    private final Boolean enabled;

    private Firehose(BuilderImpl builder) {
        this.deliveryStream = builder.deliveryStream;
        this.enabled = builder.enabled;
    }

    /**
     * Returns the value of the DeliveryStream property for this object.
     * 
     * @return The value of the DeliveryStream property for this object.
     */
    public final String deliveryStream() {
        return deliveryStream;
    }

    /**
     * Returns the value of the Enabled property for this object.
     * 
     * @return The value of the Enabled property for this object.
     */
    public final Boolean enabled() {
        return enabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deliveryStream());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Firehose)) {
            return false;
        }
        Firehose other = (Firehose) obj;
        return Objects.equals(deliveryStream(), other.deliveryStream()) && Objects.equals(enabled(), other.enabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Firehose").add("DeliveryStream", deliveryStream()).add("Enabled", enabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeliveryStream":
            return Optional.ofNullable(clazz.cast(deliveryStream()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Firehose, T> g) {
        return obj -> g.apply((Firehose) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Firehose> {
        /**
         * Sets the value of the DeliveryStream property for this object.
         *
         * @param deliveryStream
         *        The new value for the DeliveryStream property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryStream(String deliveryStream);

        /**
         * Sets the value of the Enabled property for this object.
         *
         * @param enabled
         *        The new value for the Enabled property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);
    }

    static final class BuilderImpl implements Builder {
        private String deliveryStream;

        private Boolean enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(Firehose model) {
            deliveryStream(model.deliveryStream);
            enabled(model.enabled);
        }

        public final String getDeliveryStream() {
            return deliveryStream;
        }

        public final void setDeliveryStream(String deliveryStream) {
            this.deliveryStream = deliveryStream;
        }

        @Override
        public final Builder deliveryStream(String deliveryStream) {
            this.deliveryStream = deliveryStream;
            return this;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        public Firehose build() {
            return new Firehose(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
