/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivsrealtime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration information specific to Grid layout, for server-side composition. See "Layouts" in <a
 * href="https://docs.aws.amazon.com/ivs/latest/RealTimeUserGuide/server-side-composition.html">Server-Side
 * Composition</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GridConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<GridConfiguration.Builder, GridConfiguration> {
    private static final SdkField<String> FEATURED_PARTICIPANT_ATTRIBUTE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("featuredParticipantAttribute")
            .getter(getter(GridConfiguration::featuredParticipantAttribute))
            .setter(setter(Builder::featuredParticipantAttribute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("featuredParticipantAttribute")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(FEATURED_PARTICIPANT_ATTRIBUTE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String featuredParticipantAttribute;

    private GridConfiguration(BuilderImpl builder) {
        this.featuredParticipantAttribute = builder.featuredParticipantAttribute;
    }

    /**
     * <p>
     * This attribute name identifies the featured slot. A participant with this attribute set to <code>"true"</code>
     * (as a string value) in <a>ParticipantTokenConfiguration</a> is placed in the featured slot.
     * </p>
     * 
     * @return This attribute name identifies the featured slot. A participant with this attribute set to
     *         <code>"true"</code> (as a string value) in <a>ParticipantTokenConfiguration</a> is placed in the featured
     *         slot.
     */
    public final String featuredParticipantAttribute() {
        return featuredParticipantAttribute;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(featuredParticipantAttribute());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GridConfiguration)) {
            return false;
        }
        GridConfiguration other = (GridConfiguration) obj;
        return Objects.equals(featuredParticipantAttribute(), other.featuredParticipantAttribute());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GridConfiguration").add("FeaturedParticipantAttribute", featuredParticipantAttribute()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "featuredParticipantAttribute":
            return Optional.ofNullable(clazz.cast(featuredParticipantAttribute()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GridConfiguration, T> g) {
        return obj -> g.apply((GridConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GridConfiguration> {
        /**
         * <p>
         * This attribute name identifies the featured slot. A participant with this attribute set to
         * <code>"true"</code> (as a string value) in <a>ParticipantTokenConfiguration</a> is placed in the featured
         * slot.
         * </p>
         * 
         * @param featuredParticipantAttribute
         *        This attribute name identifies the featured slot. A participant with this attribute set to
         *        <code>"true"</code> (as a string value) in <a>ParticipantTokenConfiguration</a> is placed in the
         *        featured slot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder featuredParticipantAttribute(String featuredParticipantAttribute);
    }

    static final class BuilderImpl implements Builder {
        private String featuredParticipantAttribute;

        private BuilderImpl() {
        }

        private BuilderImpl(GridConfiguration model) {
            featuredParticipantAttribute(model.featuredParticipantAttribute);
        }

        public final String getFeaturedParticipantAttribute() {
            return featuredParticipantAttribute;
        }

        public final void setFeaturedParticipantAttribute(String featuredParticipantAttribute) {
            this.featuredParticipantAttribute = featuredParticipantAttribute;
        }

        @Override
        public final Builder featuredParticipantAttribute(String featuredParticipantAttribute) {
            this.featuredParticipantAttribute = featuredParticipantAttribute;
            return this;
        }

        @Override
        public GridConfiguration build() {
            return new GridConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
