/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivsrealtime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateStorageConfigurationResponse extends IvsRealTimeResponse implements
        ToCopyableBuilder<CreateStorageConfigurationResponse.Builder, CreateStorageConfigurationResponse> {
    private static final SdkField<StorageConfiguration> STORAGE_CONFIGURATION_FIELD = SdkField
            .<StorageConfiguration> builder(MarshallingType.SDK_POJO).memberName("storageConfiguration")
            .getter(getter(CreateStorageConfigurationResponse::storageConfiguration))
            .setter(setter(Builder::storageConfiguration)).constructor(StorageConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_CONFIGURATION_FIELD));

    private final StorageConfiguration storageConfiguration;

    private CreateStorageConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.storageConfiguration = builder.storageConfiguration;
    }

    /**
     * <p>
     * The StorageConfiguration that was created.
     * </p>
     * 
     * @return The StorageConfiguration that was created.
     */
    public final StorageConfiguration storageConfiguration() {
        return storageConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(storageConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStorageConfigurationResponse)) {
            return false;
        }
        CreateStorageConfigurationResponse other = (CreateStorageConfigurationResponse) obj;
        return Objects.equals(storageConfiguration(), other.storageConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateStorageConfigurationResponse").add("StorageConfiguration", storageConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "storageConfiguration":
            return Optional.ofNullable(clazz.cast(storageConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateStorageConfigurationResponse, T> g) {
        return obj -> g.apply((CreateStorageConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IvsRealTimeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateStorageConfigurationResponse> {
        /**
         * <p>
         * The StorageConfiguration that was created.
         * </p>
         * 
         * @param storageConfiguration
         *        The StorageConfiguration that was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageConfiguration(StorageConfiguration storageConfiguration);

        /**
         * <p>
         * The StorageConfiguration that was created.
         * </p>
         * This is a convenience method that creates an instance of the {@link StorageConfiguration.Builder} avoiding
         * the need to create one manually via {@link StorageConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StorageConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #storageConfiguration(StorageConfiguration)}.
         * 
         * @param storageConfiguration
         *        a consumer that will call methods on {@link StorageConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storageConfiguration(StorageConfiguration)
         */
        default Builder storageConfiguration(Consumer<StorageConfiguration.Builder> storageConfiguration) {
            return storageConfiguration(StorageConfiguration.builder().applyMutation(storageConfiguration).build());
        }
    }

    static final class BuilderImpl extends IvsRealTimeResponse.BuilderImpl implements Builder {
        private StorageConfiguration storageConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStorageConfigurationResponse model) {
            super(model);
            storageConfiguration(model.storageConfiguration);
        }

        public final StorageConfiguration.Builder getStorageConfiguration() {
            return storageConfiguration != null ? storageConfiguration.toBuilder() : null;
        }

        public final void setStorageConfiguration(StorageConfiguration.BuilderImpl storageConfiguration) {
            this.storageConfiguration = storageConfiguration != null ? storageConfiguration.build() : null;
        }

        @Override
        public final Builder storageConfiguration(StorageConfiguration storageConfiguration) {
            this.storageConfiguration = storageConfiguration;
            return this;
        }

        @Override
        public CreateStorageConfigurationResponse build() {
            return new CreateStorageConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
