/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivsrealtime.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Object specifying a Composition resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Composition implements SdkPojo, Serializable, ToCopyableBuilder<Composition.Builder, Composition> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(Composition::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<List<Destination>> DESTINATIONS_FIELD = SdkField
            .<List<Destination>> builder(MarshallingType.LIST)
            .memberName("destinations")
            .getter(getter(Composition::destinations))
            .setter(setter(Builder::destinations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Destination> builder(MarshallingType.SDK_POJO)
                                            .constructor(Destination::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime")
            .getter(getter(Composition::endTime))
            .setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<LayoutConfiguration> LAYOUT_FIELD = SdkField
            .<LayoutConfiguration> builder(MarshallingType.SDK_POJO).memberName("layout").getter(getter(Composition::layout))
            .setter(setter(Builder::layout)).constructor(LayoutConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("layout").build()).build();

    private static final SdkField<String> STAGE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stageArn").getter(getter(Composition::stageArn)).setter(setter(Builder::stageArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stageArn").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime")
            .getter(getter(Composition::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(Composition::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(Composition::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, DESTINATIONS_FIELD,
            END_TIME_FIELD, LAYOUT_FIELD, STAGE_ARN_FIELD, START_TIME_FIELD, STATE_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final List<Destination> destinations;

    private final Instant endTime;

    private final LayoutConfiguration layout;

    private final String stageArn;

    private final Instant startTime;

    private final String state;

    private final Map<String, String> tags;

    private Composition(BuilderImpl builder) {
        this.arn = builder.arn;
        this.destinations = builder.destinations;
        this.endTime = builder.endTime;
        this.layout = builder.layout;
        this.stageArn = builder.stageArn;
        this.startTime = builder.startTime;
        this.state = builder.state;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * ARN of the Composition resource.
     * </p>
     * 
     * @return ARN of the Composition resource.
     */
    public final String arn() {
        return arn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Destinations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDestinations() {
        return destinations != null && !(destinations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Array of Destination objects. A Composition can contain either one destination (<code>channel</code> or
     * <code>s3</code>) or two (one <code>channel</code> and one <code>s3</code>).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDestinations} method.
     * </p>
     * 
     * @return Array of Destination objects. A Composition can contain either one destination (<code>channel</code> or
     *         <code>s3</code>) or two (one <code>channel</code> and one <code>s3</code>).
     */
    public final List<Destination> destinations() {
        return destinations;
    }

    /**
     * <p>
     * UTC time of the Composition end. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.
     * </p>
     * 
     * @return UTC time of the Composition end. This is an ISO 8601 timestamp; <i>note that this is returned as a
     *         string</i>.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * Layout object to configure composition parameters.
     * </p>
     * 
     * @return Layout object to configure composition parameters.
     */
    public final LayoutConfiguration layout() {
        return layout;
    }

    /**
     * <p>
     * ARN of the stage used as input
     * </p>
     * 
     * @return ARN of the stage used as input
     */
    public final String stageArn() {
        return stageArn;
    }

    /**
     * <p>
     * UTC time of the Composition start. This is an ISO 8601 timestamp; <i>note that this is returned as a string</i>.
     * </p>
     * 
     * @return UTC time of the Composition start. This is an ISO 8601 timestamp; <i>note that this is returned as a
     *         string</i>.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * State of the Composition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CompositionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return State of the Composition.
     * @see CompositionState
     */
    public final CompositionState state() {
        return CompositionState.fromValue(state);
    }

    /**
     * <p>
     * State of the Composition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CompositionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return State of the Composition.
     * @see CompositionState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>. See <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a> for details,
     * including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no constraints
     * on tags beyond what is documented there.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>.
     *         See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a>
     *         for details, including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon
     *         IVS has no constraints on tags beyond what is documented there.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(hasDestinations() ? destinations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(layout());
        hashCode = 31 * hashCode + Objects.hashCode(stageArn());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Composition)) {
            return false;
        }
        Composition other = (Composition) obj;
        return Objects.equals(arn(), other.arn()) && hasDestinations() == other.hasDestinations()
                && Objects.equals(destinations(), other.destinations()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(layout(), other.layout()) && Objects.equals(stageArn(), other.stageArn())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(stateAsString(), other.stateAsString())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Composition").add("Arn", arn()).add("Destinations", hasDestinations() ? destinations() : null)
                .add("EndTime", endTime()).add("Layout", layout()).add("StageArn", stageArn()).add("StartTime", startTime())
                .add("State", stateAsString()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "destinations":
            return Optional.ofNullable(clazz.cast(destinations()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "layout":
            return Optional.ofNullable(clazz.cast(layout()));
        case "stageArn":
            return Optional.ofNullable(clazz.cast(stageArn()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Composition, T> g) {
        return obj -> g.apply((Composition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Composition> {
        /**
         * <p>
         * ARN of the Composition resource.
         * </p>
         * 
         * @param arn
         *        ARN of the Composition resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Array of Destination objects. A Composition can contain either one destination (<code>channel</code> or
         * <code>s3</code>) or two (one <code>channel</code> and one <code>s3</code>).
         * </p>
         * 
         * @param destinations
         *        Array of Destination objects. A Composition can contain either one destination (<code>channel</code>
         *        or <code>s3</code>) or two (one <code>channel</code> and one <code>s3</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinations(Collection<Destination> destinations);

        /**
         * <p>
         * Array of Destination objects. A Composition can contain either one destination (<code>channel</code> or
         * <code>s3</code>) or two (one <code>channel</code> and one <code>s3</code>).
         * </p>
         * 
         * @param destinations
         *        Array of Destination objects. A Composition can contain either one destination (<code>channel</code>
         *        or <code>s3</code>) or two (one <code>channel</code> and one <code>s3</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinations(Destination... destinations);

        /**
         * <p>
         * Array of Destination objects. A Composition can contain either one destination (<code>channel</code> or
         * <code>s3</code>) or two (one <code>channel</code> and one <code>s3</code>).
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ivsrealtime.model.Destination.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ivsrealtime.model.Destination#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ivsrealtime.model.Destination.Builder#build()} is called immediately
         * and its result is passed to {@link #destinations(List<Destination>)}.
         * 
         * @param destinations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ivsrealtime.model.Destination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinations(java.util.Collection<Destination>)
         */
        Builder destinations(Consumer<Destination.Builder>... destinations);

        /**
         * <p>
         * UTC time of the Composition end. This is an ISO 8601 timestamp; <i>note that this is returned as a
         * string</i>.
         * </p>
         * 
         * @param endTime
         *        UTC time of the Composition end. This is an ISO 8601 timestamp; <i>note that this is returned as a
         *        string</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * Layout object to configure composition parameters.
         * </p>
         * 
         * @param layout
         *        Layout object to configure composition parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layout(LayoutConfiguration layout);

        /**
         * <p>
         * Layout object to configure composition parameters.
         * </p>
         * This is a convenience method that creates an instance of the {@link LayoutConfiguration.Builder} avoiding the
         * need to create one manually via {@link LayoutConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LayoutConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #layout(LayoutConfiguration)}.
         * 
         * @param layout
         *        a consumer that will call methods on {@link LayoutConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #layout(LayoutConfiguration)
         */
        default Builder layout(Consumer<LayoutConfiguration.Builder> layout) {
            return layout(LayoutConfiguration.builder().applyMutation(layout).build());
        }

        /**
         * <p>
         * ARN of the stage used as input
         * </p>
         * 
         * @param stageArn
         *        ARN of the stage used as input
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageArn(String stageArn);

        /**
         * <p>
         * UTC time of the Composition start. This is an ISO 8601 timestamp; <i>note that this is returned as a
         * string</i>.
         * </p>
         * 
         * @param startTime
         *        UTC time of the Composition start. This is an ISO 8601 timestamp; <i>note that this is returned as a
         *        string</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * State of the Composition.
         * </p>
         * 
         * @param state
         *        State of the Composition.
         * @see CompositionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CompositionState
         */
        Builder state(String state);

        /**
         * <p>
         * State of the Composition.
         * </p>
         * 
         * @param state
         *        State of the Composition.
         * @see CompositionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CompositionState
         */
        Builder state(CompositionState state);

        /**
         * <p>
         * Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>. See <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a> for details,
         * including restrictions that apply to tags and "Tag naming limits and requirements"; Amazon IVS has no
         * constraints on tags beyond what is documented there.
         * </p>
         * 
         * @param tags
         *        Tags attached to the resource. Array of maps, each of the form <code>string:string (key:value)</code>.
         *        See <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a>
         *        for details, including restrictions that apply to tags and "Tag naming limits and requirements";
         *        Amazon IVS has no constraints on tags beyond what is documented there.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private List<Destination> destinations = DefaultSdkAutoConstructList.getInstance();

        private Instant endTime;

        private LayoutConfiguration layout;

        private String stageArn;

        private Instant startTime;

        private String state;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Composition model) {
            arn(model.arn);
            destinations(model.destinations);
            endTime(model.endTime);
            layout(model.layout);
            stageArn(model.stageArn);
            startTime(model.startTime);
            state(model.state);
            tags(model.tags);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final List<Destination.Builder> getDestinations() {
            List<Destination.Builder> result = DestinationListCopier.copyToBuilder(this.destinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDestinations(Collection<Destination.BuilderImpl> destinations) {
            this.destinations = DestinationListCopier.copyFromBuilder(destinations);
        }

        @Override
        public final Builder destinations(Collection<Destination> destinations) {
            this.destinations = DestinationListCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Destination... destinations) {
            destinations(Arrays.asList(destinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Consumer<Destination.Builder>... destinations) {
            destinations(Stream.of(destinations).map(c -> Destination.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final LayoutConfiguration.Builder getLayout() {
            return layout != null ? layout.toBuilder() : null;
        }

        public final void setLayout(LayoutConfiguration.BuilderImpl layout) {
            this.layout = layout != null ? layout.build() : null;
        }

        @Override
        public final Builder layout(LayoutConfiguration layout) {
            this.layout = layout;
            return this;
        }

        public final String getStageArn() {
            return stageArn;
        }

        public final void setStageArn(String stageArn) {
            this.stageArn = stageArn;
        }

        @Override
        public final Builder stageArn(String stageArn) {
            this.stageArn = stageArn;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CompositionState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Composition build() {
            return new Composition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
