/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivsrealtime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Object specifying a channel as a destination.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChannelDestinationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ChannelDestinationConfiguration.Builder, ChannelDestinationConfiguration> {
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("channelArn").getter(getter(ChannelDestinationConfiguration::channelArn))
            .setter(setter(Builder::channelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelArn").build()).build();

    private static final SdkField<String> ENCODER_CONFIGURATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("encoderConfigurationArn").getter(getter(ChannelDestinationConfiguration::encoderConfigurationArn))
            .setter(setter(Builder::encoderConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encoderConfigurationArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ARN_FIELD,
            ENCODER_CONFIGURATION_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String channelArn;

    private final String encoderConfigurationArn;

    private ChannelDestinationConfiguration(BuilderImpl builder) {
        this.channelArn = builder.channelArn;
        this.encoderConfigurationArn = builder.encoderConfigurationArn;
    }

    /**
     * <p>
     * ARN of the channel to use for broadcasting. The channel and stage resources must be in the same AWS account and
     * region. The channel must be offline (not broadcasting).
     * </p>
     * 
     * @return ARN of the channel to use for broadcasting. The channel and stage resources must be in the same AWS
     *         account and region. The channel must be offline (not broadcasting).
     */
    public final String channelArn() {
        return channelArn;
    }

    /**
     * <p>
     * ARN of the <a>EncoderConfiguration</a> resource. The encoder configuration and stage resources must be in the
     * same AWS account and region.
     * </p>
     * 
     * @return ARN of the <a>EncoderConfiguration</a> resource. The encoder configuration and stage resources must be in
     *         the same AWS account and region.
     */
    public final String encoderConfigurationArn() {
        return encoderConfigurationArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(encoderConfigurationArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChannelDestinationConfiguration)) {
            return false;
        }
        ChannelDestinationConfiguration other = (ChannelDestinationConfiguration) obj;
        return Objects.equals(channelArn(), other.channelArn())
                && Objects.equals(encoderConfigurationArn(), other.encoderConfigurationArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChannelDestinationConfiguration").add("ChannelArn", channelArn())
                .add("EncoderConfigurationArn", encoderConfigurationArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "channelArn":
            return Optional.ofNullable(clazz.cast(channelArn()));
        case "encoderConfigurationArn":
            return Optional.ofNullable(clazz.cast(encoderConfigurationArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChannelDestinationConfiguration, T> g) {
        return obj -> g.apply((ChannelDestinationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChannelDestinationConfiguration> {
        /**
         * <p>
         * ARN of the channel to use for broadcasting. The channel and stage resources must be in the same AWS account
         * and region. The channel must be offline (not broadcasting).
         * </p>
         * 
         * @param channelArn
         *        ARN of the channel to use for broadcasting. The channel and stage resources must be in the same AWS
         *        account and region. The channel must be offline (not broadcasting).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelArn(String channelArn);

        /**
         * <p>
         * ARN of the <a>EncoderConfiguration</a> resource. The encoder configuration and stage resources must be in the
         * same AWS account and region.
         * </p>
         * 
         * @param encoderConfigurationArn
         *        ARN of the <a>EncoderConfiguration</a> resource. The encoder configuration and stage resources must be
         *        in the same AWS account and region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encoderConfigurationArn(String encoderConfigurationArn);
    }

    static final class BuilderImpl implements Builder {
        private String channelArn;

        private String encoderConfigurationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ChannelDestinationConfiguration model) {
            channelArn(model.channelArn);
            encoderConfigurationArn(model.encoderConfigurationArn);
        }

        public final String getChannelArn() {
            return channelArn;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        @Override
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final String getEncoderConfigurationArn() {
            return encoderConfigurationArn;
        }

        public final void setEncoderConfigurationArn(String encoderConfigurationArn) {
            this.encoderConfigurationArn = encoderConfigurationArn;
        }

        @Override
        public final Builder encoderConfigurationArn(String encoderConfigurationArn) {
            this.encoderConfigurationArn = encoderConfigurationArn;
            return this;
        }

        @Override
        public ChannelDestinationConfiguration build() {
            return new ChannelDestinationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
