/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivsrealtime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ivsrealtime.model.IvsRealTimeResponse;
import software.amazon.awssdk.services.ivsrealtime.model.ParticipantListCopier;
import software.amazon.awssdk.services.ivsrealtime.model.ParticipantSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListParticipantsResponse
extends IvsRealTimeResponse
implements ToCopyableBuilder<Builder, ListParticipantsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListParticipantsResponse.getter(ListParticipantsResponse::nextToken)).setter(ListParticipantsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<ParticipantSummary>> PARTICIPANTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("participants").getter(ListParticipantsResponse.getter(ListParticipantsResponse::participants)).setter(ListParticipantsResponse.setter(Builder::participants)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("participants").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ParticipantSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, PARTICIPANTS_FIELD));
    private final String nextToken;
    private final List<ParticipantSummary> participants;

    private ListParticipantsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.participants = builder.participants;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasParticipants() {
        return this.participants != null && !(this.participants instanceof SdkAutoConstructList);
    }

    public final List<ParticipantSummary> participants() {
        return this.participants;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParticipants() ? this.participants() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListParticipantsResponse)) {
            return false;
        }
        ListParticipantsResponse other = (ListParticipantsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasParticipants() == other.hasParticipants() && Objects.equals(this.participants(), other.participants());
    }

    public final String toString() {
        return ToString.builder((String)"ListParticipantsResponse").add("NextToken", (Object)this.nextToken()).add("Participants", this.hasParticipants() ? this.participants() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "participants": {
                return Optional.ofNullable(clazz.cast(this.participants()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListParticipantsResponse, T> g) {
        return obj -> g.apply((ListParticipantsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IvsRealTimeResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ParticipantSummary> participants = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListParticipantsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.participants(model.participants);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ParticipantSummary.Builder> getParticipants() {
            List<ParticipantSummary.Builder> result = ParticipantListCopier.copyToBuilder(this.participants);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParticipants(Collection<ParticipantSummary.BuilderImpl> participants) {
            this.participants = ParticipantListCopier.copyFromBuilder(participants);
        }

        @Override
        public final Builder participants(Collection<ParticipantSummary> participants) {
            this.participants = ParticipantListCopier.copy(participants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder participants(ParticipantSummary ... participants) {
            this.participants(Arrays.asList(participants));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder participants(Consumer<ParticipantSummary.Builder> ... participants) {
            this.participants(Stream.of(participants).map(c -> (ParticipantSummary)((ParticipantSummary.Builder)ParticipantSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListParticipantsResponse build() {
            return new ListParticipantsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IvsRealTimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListParticipantsResponse> {
        public Builder nextToken(String var1);

        public Builder participants(Collection<ParticipantSummary> var1);

        public Builder participants(ParticipantSummary ... var1);

        public Builder participants(Consumer<ParticipantSummary.Builder> ... var1);
    }
}

