/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Error for a request in the batch for BatchStartViewerSessionRevocation. Each error is related to a specific
 * channel-ARN and viewer-ID pair.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchStartViewerSessionRevocationError implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchStartViewerSessionRevocationError.Builder, BatchStartViewerSessionRevocationError> {
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("channelArn").getter(getter(BatchStartViewerSessionRevocationError::channelArn))
            .setter(setter(Builder::channelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelArn").build()).build();

    private static final SdkField<String> CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("code")
            .getter(getter(BatchStartViewerSessionRevocationError::code)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("code").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(BatchStartViewerSessionRevocationError::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final SdkField<String> VIEWER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("viewerId").getter(getter(BatchStartViewerSessionRevocationError::viewerId))
            .setter(setter(Builder::viewerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("viewerId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ARN_FIELD, CODE_FIELD,
            MESSAGE_FIELD, VIEWER_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String channelArn;

    private final String code;

    private final String message;

    private final String viewerId;

    private BatchStartViewerSessionRevocationError(BuilderImpl builder) {
        this.channelArn = builder.channelArn;
        this.code = builder.code;
        this.message = builder.message;
        this.viewerId = builder.viewerId;
    }

    /**
     * <p>
     * Channel ARN.
     * </p>
     * 
     * @return Channel ARN.
     */
    public final String channelArn() {
        return channelArn;
    }

    /**
     * <p>
     * Error code.
     * </p>
     * 
     * @return Error code.
     */
    public final String code() {
        return code;
    }

    /**
     * <p>
     * Error message, determined by the application.
     * </p>
     * 
     * @return Error message, determined by the application.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The ID of the viewer session to revoke.
     * </p>
     * 
     * @return The ID of the viewer session to revoke.
     */
    public final String viewerId() {
        return viewerId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(code());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(viewerId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchStartViewerSessionRevocationError)) {
            return false;
        }
        BatchStartViewerSessionRevocationError other = (BatchStartViewerSessionRevocationError) obj;
        return Objects.equals(channelArn(), other.channelArn()) && Objects.equals(code(), other.code())
                && Objects.equals(message(), other.message()) && Objects.equals(viewerId(), other.viewerId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchStartViewerSessionRevocationError").add("ChannelArn", channelArn()).add("Code", code())
                .add("Message", message()).add("ViewerId", viewerId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "channelArn":
            return Optional.ofNullable(clazz.cast(channelArn()));
        case "code":
            return Optional.ofNullable(clazz.cast(code()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        case "viewerId":
            return Optional.ofNullable(clazz.cast(viewerId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchStartViewerSessionRevocationError, T> g) {
        return obj -> g.apply((BatchStartViewerSessionRevocationError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchStartViewerSessionRevocationError> {
        /**
         * <p>
         * Channel ARN.
         * </p>
         * 
         * @param channelArn
         *        Channel ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelArn(String channelArn);

        /**
         * <p>
         * Error code.
         * </p>
         * 
         * @param code
         *        Error code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(String code);

        /**
         * <p>
         * Error message, determined by the application.
         * </p>
         * 
         * @param message
         *        Error message, determined by the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The ID of the viewer session to revoke.
         * </p>
         * 
         * @param viewerId
         *        The ID of the viewer session to revoke.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder viewerId(String viewerId);
    }

    static final class BuilderImpl implements Builder {
        private String channelArn;

        private String code;

        private String message;

        private String viewerId;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchStartViewerSessionRevocationError model) {
            channelArn(model.channelArn);
            code(model.code);
            message(model.message);
            viewerId(model.viewerId);
        }

        public final String getChannelArn() {
            return channelArn;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        @Override
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final String getCode() {
            return code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getViewerId() {
            return viewerId;
        }

        public final void setViewerId(String viewerId) {
            this.viewerId = viewerId;
        }

        @Override
        public final Builder viewerId(String viewerId) {
            this.viewerId = viewerId;
            return this;
        }

        @Override
        public BatchStartViewerSessionRevocationError build() {
            return new BatchStartViewerSessionRevocationError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
