/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessResponse;
import software.amazon.awssdk.services.iotwireless.model.SidewalkAccountInfoWithFingerprint;
import software.amazon.awssdk.services.iotwireless.model.SidewalkAccountListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPartnerAccountsResponse
extends IotWirelessResponse
implements ToCopyableBuilder<Builder, ListPartnerAccountsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListPartnerAccountsResponse.getter(ListPartnerAccountsResponse::nextToken)).setter(ListPartnerAccountsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<SidewalkAccountInfoWithFingerprint>> SIDEWALK_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Sidewalk").getter(ListPartnerAccountsResponse.getter(ListPartnerAccountsResponse::sidewalk)).setter(ListPartnerAccountsResponse.setter(Builder::sidewalk)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sidewalk").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SidewalkAccountInfoWithFingerprint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, SIDEWALK_FIELD));
    private final String nextToken;
    private final List<SidewalkAccountInfoWithFingerprint> sidewalk;

    private ListPartnerAccountsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.sidewalk = builder.sidewalk;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasSidewalk() {
        return this.sidewalk != null && !(this.sidewalk instanceof SdkAutoConstructList);
    }

    public final List<SidewalkAccountInfoWithFingerprint> sidewalk() {
        return this.sidewalk;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSidewalk() ? this.sidewalk() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPartnerAccountsResponse)) {
            return false;
        }
        ListPartnerAccountsResponse other = (ListPartnerAccountsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasSidewalk() == other.hasSidewalk() && Objects.equals(this.sidewalk(), other.sidewalk());
    }

    public final String toString() {
        return ToString.builder((String)"ListPartnerAccountsResponse").add("NextToken", (Object)this.nextToken()).add("Sidewalk", this.hasSidewalk() ? this.sidewalk() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Sidewalk": {
                return Optional.ofNullable(clazz.cast(this.sidewalk()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPartnerAccountsResponse, T> g) {
        return obj -> g.apply((ListPartnerAccountsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotWirelessResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<SidewalkAccountInfoWithFingerprint> sidewalk = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListPartnerAccountsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.sidewalk(model.sidewalk);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<SidewalkAccountInfoWithFingerprint.Builder> getSidewalk() {
            List<SidewalkAccountInfoWithFingerprint.Builder> result = SidewalkAccountListCopier.copyToBuilder(this.sidewalk);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSidewalk(Collection<SidewalkAccountInfoWithFingerprint.BuilderImpl> sidewalk) {
            this.sidewalk = SidewalkAccountListCopier.copyFromBuilder(sidewalk);
        }

        @Override
        public final Builder sidewalk(Collection<SidewalkAccountInfoWithFingerprint> sidewalk) {
            this.sidewalk = SidewalkAccountListCopier.copy(sidewalk);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sidewalk(SidewalkAccountInfoWithFingerprint ... sidewalk) {
            this.sidewalk(Arrays.asList(sidewalk));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sidewalk(Consumer<SidewalkAccountInfoWithFingerprint.Builder> ... sidewalk) {
            this.sidewalk(Stream.of(sidewalk).map(c -> (SidewalkAccountInfoWithFingerprint)((SidewalkAccountInfoWithFingerprint.Builder)SidewalkAccountInfoWithFingerprint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListPartnerAccountsResponse build() {
            return new ListPartnerAccountsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotWirelessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPartnerAccountsResponse> {
        public Builder nextToken(String var1);

        public Builder sidewalk(Collection<SidewalkAccountInfoWithFingerprint> var1);

        public Builder sidewalk(SidewalkAccountInfoWithFingerprint ... var1);

        public Builder sidewalk(Consumer<SidewalkAccountInfoWithFingerprint.Builder> ... var1);
    }
}

