/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotwireless.model.OnboardStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportedSidewalkDevice
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImportedSidewalkDevice> {
    private static final SdkField<String> SIDEWALK_MANUFACTURING_SN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SidewalkManufacturingSn").getter(ImportedSidewalkDevice.getter(ImportedSidewalkDevice::sidewalkManufacturingSn)).setter(ImportedSidewalkDevice.setter(Builder::sidewalkManufacturingSn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SidewalkManufacturingSn").build()}).build();
    private static final SdkField<String> ONBOARDING_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OnboardingStatus").getter(ImportedSidewalkDevice.getter(ImportedSidewalkDevice::onboardingStatusAsString)).setter(ImportedSidewalkDevice.setter(Builder::onboardingStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnboardingStatus").build()}).build();
    private static final SdkField<String> ONBOARDING_STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OnboardingStatusReason").getter(ImportedSidewalkDevice.getter(ImportedSidewalkDevice::onboardingStatusReason)).setter(ImportedSidewalkDevice.setter(Builder::onboardingStatusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnboardingStatusReason").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdateTime").getter(ImportedSidewalkDevice.getter(ImportedSidewalkDevice::lastUpdateTime)).setter(ImportedSidewalkDevice.setter(Builder::lastUpdateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIDEWALK_MANUFACTURING_SN_FIELD, ONBOARDING_STATUS_FIELD, ONBOARDING_STATUS_REASON_FIELD, LAST_UPDATE_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String sidewalkManufacturingSn;
    private final String onboardingStatus;
    private final String onboardingStatusReason;
    private final Instant lastUpdateTime;

    private ImportedSidewalkDevice(BuilderImpl builder) {
        this.sidewalkManufacturingSn = builder.sidewalkManufacturingSn;
        this.onboardingStatus = builder.onboardingStatus;
        this.onboardingStatusReason = builder.onboardingStatusReason;
        this.lastUpdateTime = builder.lastUpdateTime;
    }

    public final String sidewalkManufacturingSn() {
        return this.sidewalkManufacturingSn;
    }

    public final OnboardStatus onboardingStatus() {
        return OnboardStatus.fromValue(this.onboardingStatus);
    }

    public final String onboardingStatusAsString() {
        return this.onboardingStatus;
    }

    public final String onboardingStatusReason() {
        return this.onboardingStatusReason;
    }

    public final Instant lastUpdateTime() {
        return this.lastUpdateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sidewalkManufacturingSn());
        hashCode = 31 * hashCode + Objects.hashCode(this.onboardingStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.onboardingStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportedSidewalkDevice)) {
            return false;
        }
        ImportedSidewalkDevice other = (ImportedSidewalkDevice)obj;
        return Objects.equals(this.sidewalkManufacturingSn(), other.sidewalkManufacturingSn()) && Objects.equals(this.onboardingStatusAsString(), other.onboardingStatusAsString()) && Objects.equals(this.onboardingStatusReason(), other.onboardingStatusReason()) && Objects.equals(this.lastUpdateTime(), other.lastUpdateTime());
    }

    public final String toString() {
        return ToString.builder((String)"ImportedSidewalkDevice").add("SidewalkManufacturingSn", (Object)this.sidewalkManufacturingSn()).add("OnboardingStatus", (Object)this.onboardingStatusAsString()).add("OnboardingStatusReason", (Object)this.onboardingStatusReason()).add("LastUpdateTime", (Object)this.lastUpdateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SidewalkManufacturingSn": {
                return Optional.ofNullable(clazz.cast(this.sidewalkManufacturingSn()));
            }
            case "OnboardingStatus": {
                return Optional.ofNullable(clazz.cast(this.onboardingStatusAsString()));
            }
            case "OnboardingStatusReason": {
                return Optional.ofNullable(clazz.cast(this.onboardingStatusReason()));
            }
            case "LastUpdateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportedSidewalkDevice, T> g) {
        return obj -> g.apply((ImportedSidewalkDevice)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sidewalkManufacturingSn;
        private String onboardingStatus;
        private String onboardingStatusReason;
        private Instant lastUpdateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportedSidewalkDevice model) {
            this.sidewalkManufacturingSn(model.sidewalkManufacturingSn);
            this.onboardingStatus(model.onboardingStatus);
            this.onboardingStatusReason(model.onboardingStatusReason);
            this.lastUpdateTime(model.lastUpdateTime);
        }

        public final String getSidewalkManufacturingSn() {
            return this.sidewalkManufacturingSn;
        }

        public final void setSidewalkManufacturingSn(String sidewalkManufacturingSn) {
            this.sidewalkManufacturingSn = sidewalkManufacturingSn;
        }

        @Override
        public final Builder sidewalkManufacturingSn(String sidewalkManufacturingSn) {
            this.sidewalkManufacturingSn = sidewalkManufacturingSn;
            return this;
        }

        public final String getOnboardingStatus() {
            return this.onboardingStatus;
        }

        public final void setOnboardingStatus(String onboardingStatus) {
            this.onboardingStatus = onboardingStatus;
        }

        @Override
        public final Builder onboardingStatus(String onboardingStatus) {
            this.onboardingStatus = onboardingStatus;
            return this;
        }

        @Override
        public final Builder onboardingStatus(OnboardStatus onboardingStatus) {
            this.onboardingStatus(onboardingStatus == null ? null : onboardingStatus.toString());
            return this;
        }

        public final String getOnboardingStatusReason() {
            return this.onboardingStatusReason;
        }

        public final void setOnboardingStatusReason(String onboardingStatusReason) {
            this.onboardingStatusReason = onboardingStatusReason;
        }

        @Override
        public final Builder onboardingStatusReason(String onboardingStatusReason) {
            this.onboardingStatusReason = onboardingStatusReason;
            return this;
        }

        public final Instant getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public ImportedSidewalkDevice build() {
            return new ImportedSidewalkDevice(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImportedSidewalkDevice> {
        public Builder sidewalkManufacturingSn(String var1);

        public Builder onboardingStatus(String var1);

        public Builder onboardingStatus(OnboardStatus var1);

        public Builder onboardingStatusReason(String var1);

        public Builder lastUpdateTime(Instant var1);
    }
}

