/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DeviceState {
    PROVISIONED("Provisioned"),
    REGISTERED_NOT_SEEN("RegisteredNotSeen"),
    REGISTERED_REACHABLE("RegisteredReachable"),
    REGISTERED_UNREACHABLE("RegisteredUnreachable"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DeviceState> VALUE_MAP;
    private final String value;

    private DeviceState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeviceState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeviceState> knownValues() {
        EnumSet<DeviceState> knownValues = EnumSet.allOf(DeviceState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DeviceState.class, DeviceState::toString);
    }
}

