/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DeviceProfileType {
    SIDEWALK("Sidewalk"),
    LO_RA_WAN("LoRaWAN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DeviceProfileType> VALUE_MAP;
    private final String value;

    private DeviceProfileType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeviceProfileType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeviceProfileType> knownValues() {
        EnumSet<DeviceProfileType> knownValues = EnumSet.allOf(DeviceProfileType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DeviceProfileType.class, DeviceProfileType::toString);
    }
}

