/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The history of values for a time series property.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PropertyValueHistory implements SdkPojo, Serializable,
        ToCopyableBuilder<PropertyValueHistory.Builder, PropertyValueHistory> {
    private static final SdkField<EntityPropertyReference> ENTITY_PROPERTY_REFERENCE_FIELD = SdkField
            .<EntityPropertyReference> builder(MarshallingType.SDK_POJO).memberName("entityPropertyReference")
            .getter(getter(PropertyValueHistory::entityPropertyReference)).setter(setter(Builder::entityPropertyReference))
            .constructor(EntityPropertyReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityPropertyReference").build())
            .build();

    private static final SdkField<List<PropertyValue>> VALUES_FIELD = SdkField
            .<List<PropertyValue>> builder(MarshallingType.LIST)
            .memberName("values")
            .getter(getter(PropertyValueHistory::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PropertyValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(PropertyValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ENTITY_PROPERTY_REFERENCE_FIELD, VALUES_FIELD));

    private static final long serialVersionUID = 1L;

    private final EntityPropertyReference entityPropertyReference;

    private final List<PropertyValue> values;

    private PropertyValueHistory(BuilderImpl builder) {
        this.entityPropertyReference = builder.entityPropertyReference;
        this.values = builder.values;
    }

    /**
     * <p>
     * An object that uniquely identifies an entity property.
     * </p>
     * 
     * @return An object that uniquely identifies an entity property.
     */
    public final EntityPropertyReference entityPropertyReference() {
        return entityPropertyReference;
    }

    /**
     * For responses, this returns true if the service returned a value for the Values property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of objects that contain information about the values in the history of a time series property.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValues} method.
     * </p>
     * 
     * @return A list of objects that contain information about the values in the history of a time series property.
     */
    public final List<PropertyValue> values() {
        return values;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(entityPropertyReference());
        hashCode = 31 * hashCode + Objects.hashCode(hasValues() ? values() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PropertyValueHistory)) {
            return false;
        }
        PropertyValueHistory other = (PropertyValueHistory) obj;
        return Objects.equals(entityPropertyReference(), other.entityPropertyReference()) && hasValues() == other.hasValues()
                && Objects.equals(values(), other.values());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PropertyValueHistory").add("EntityPropertyReference", entityPropertyReference())
                .add("Values", hasValues() ? values() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "entityPropertyReference":
            return Optional.ofNullable(clazz.cast(entityPropertyReference()));
        case "values":
            return Optional.ofNullable(clazz.cast(values()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PropertyValueHistory, T> g) {
        return obj -> g.apply((PropertyValueHistory) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PropertyValueHistory> {
        /**
         * <p>
         * An object that uniquely identifies an entity property.
         * </p>
         * 
         * @param entityPropertyReference
         *        An object that uniquely identifies an entity property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityPropertyReference(EntityPropertyReference entityPropertyReference);

        /**
         * <p>
         * An object that uniquely identifies an entity property.
         * </p>
         * This is a convenience method that creates an instance of the {@link EntityPropertyReference.Builder} avoiding
         * the need to create one manually via {@link EntityPropertyReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EntityPropertyReference.Builder#build()} is called immediately
         * and its result is passed to {@link #entityPropertyReference(EntityPropertyReference)}.
         * 
         * @param entityPropertyReference
         *        a consumer that will call methods on {@link EntityPropertyReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entityPropertyReference(EntityPropertyReference)
         */
        default Builder entityPropertyReference(Consumer<EntityPropertyReference.Builder> entityPropertyReference) {
            return entityPropertyReference(EntityPropertyReference.builder().applyMutation(entityPropertyReference).build());
        }

        /**
         * <p>
         * A list of objects that contain information about the values in the history of a time series property.
         * </p>
         * 
         * @param values
         *        A list of objects that contain information about the values in the history of a time series property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<PropertyValue> values);

        /**
         * <p>
         * A list of objects that contain information about the values in the history of a time series property.
         * </p>
         * 
         * @param values
         *        A list of objects that contain information about the values in the history of a time series property.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(PropertyValue... values);

        /**
         * <p>
         * A list of objects that contain information about the values in the history of a time series property.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iottwinmaker.model.PropertyValue.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.iottwinmaker.model.PropertyValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iottwinmaker.model.PropertyValue.Builder#build()} is called
         * immediately and its result is passed to {@link #values(List<PropertyValue>)}.
         * 
         * @param values
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iottwinmaker.model.PropertyValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #values(java.util.Collection<PropertyValue>)
         */
        Builder values(Consumer<PropertyValue.Builder>... values);
    }

    static final class BuilderImpl implements Builder {
        private EntityPropertyReference entityPropertyReference;

        private List<PropertyValue> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PropertyValueHistory model) {
            entityPropertyReference(model.entityPropertyReference);
            values(model.values);
        }

        public final EntityPropertyReference.Builder getEntityPropertyReference() {
            return entityPropertyReference != null ? entityPropertyReference.toBuilder() : null;
        }

        public final void setEntityPropertyReference(EntityPropertyReference.BuilderImpl entityPropertyReference) {
            this.entityPropertyReference = entityPropertyReference != null ? entityPropertyReference.build() : null;
        }

        @Override
        public final Builder entityPropertyReference(EntityPropertyReference entityPropertyReference) {
            this.entityPropertyReference = entityPropertyReference;
            return this;
        }

        public final List<PropertyValue.Builder> getValues() {
            List<PropertyValue.Builder> result = ValuesCopier.copyToBuilder(this.values);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValues(Collection<PropertyValue.BuilderImpl> values) {
            this.values = ValuesCopier.copyFromBuilder(values);
        }

        @Override
        public final Builder values(Collection<PropertyValue> values) {
            this.values = ValuesCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(PropertyValue... values) {
            values(Arrays.asList(values));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(Consumer<PropertyValue.Builder>... values) {
            values(Stream.of(values).map(c -> PropertyValue.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public PropertyValueHistory build() {
            return new PropertyValueHistory(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
