/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSceneRequest extends IoTTwinMakerRequest implements
        ToCopyableBuilder<CreateSceneRequest.Builder, CreateSceneRequest> {
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workspaceId").getter(getter(CreateSceneRequest::workspaceId)).setter(setter(Builder::workspaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("workspaceId").build()).build();

    private static final SdkField<String> SCENE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sceneId").getter(getter(CreateSceneRequest::sceneId)).setter(setter(Builder::sceneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sceneId").build()).build();

    private static final SdkField<String> CONTENT_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contentLocation").getter(getter(CreateSceneRequest::contentLocation))
            .setter(setter(Builder::contentLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentLocation").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateSceneRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<String>> CAPABILITIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("capabilities")
            .getter(getter(CreateSceneRequest::capabilities))
            .setter(setter(Builder::capabilities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capabilities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateSceneRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> SCENE_METADATA_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("sceneMetadata")
            .getter(getter(CreateSceneRequest::sceneMetadata))
            .setter(setter(Builder::sceneMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sceneMetadata").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKSPACE_ID_FIELD,
            SCENE_ID_FIELD, CONTENT_LOCATION_FIELD, DESCRIPTION_FIELD, CAPABILITIES_FIELD, TAGS_FIELD, SCENE_METADATA_FIELD));

    private final String workspaceId;

    private final String sceneId;

    private final String contentLocation;

    private final String description;

    private final List<String> capabilities;

    private final Map<String, String> tags;

    private final Map<String, String> sceneMetadata;

    private CreateSceneRequest(BuilderImpl builder) {
        super(builder);
        this.workspaceId = builder.workspaceId;
        this.sceneId = builder.sceneId;
        this.contentLocation = builder.contentLocation;
        this.description = builder.description;
        this.capabilities = builder.capabilities;
        this.tags = builder.tags;
        this.sceneMetadata = builder.sceneMetadata;
    }

    /**
     * <p>
     * The ID of the workspace that contains the scene.
     * </p>
     * 
     * @return The ID of the workspace that contains the scene.
     */
    public final String workspaceId() {
        return workspaceId;
    }

    /**
     * <p>
     * The ID of the scene.
     * </p>
     * 
     * @return The ID of the scene.
     */
    public final String sceneId() {
        return sceneId;
    }

    /**
     * <p>
     * The relative path that specifies the location of the content definition file.
     * </p>
     * 
     * @return The relative path that specifies the location of the content definition file.
     */
    public final String contentLocation() {
        return contentLocation;
    }

    /**
     * <p>
     * The description for this scene.
     * </p>
     * 
     * @return The description for this scene.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Capabilities property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCapabilities() {
        return capabilities != null && !(capabilities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of capabilities that the scene uses to render itself.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCapabilities} method.
     * </p>
     * 
     * @return A list of capabilities that the scene uses to render itself.
     */
    public final List<String> capabilities() {
        return capabilities;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Metadata that you can use to manage the scene.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Metadata that you can use to manage the scene.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the SceneMetadata property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSceneMetadata() {
        return sceneMetadata != null && !(sceneMetadata instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The request metadata.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSceneMetadata} method.
     * </p>
     * 
     * @return The request metadata.
     */
    public final Map<String, String> sceneMetadata() {
        return sceneMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workspaceId());
        hashCode = 31 * hashCode + Objects.hashCode(sceneId());
        hashCode = 31 * hashCode + Objects.hashCode(contentLocation());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasCapabilities() ? capabilities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSceneMetadata() ? sceneMetadata() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSceneRequest)) {
            return false;
        }
        CreateSceneRequest other = (CreateSceneRequest) obj;
        return Objects.equals(workspaceId(), other.workspaceId()) && Objects.equals(sceneId(), other.sceneId())
                && Objects.equals(contentLocation(), other.contentLocation())
                && Objects.equals(description(), other.description()) && hasCapabilities() == other.hasCapabilities()
                && Objects.equals(capabilities(), other.capabilities()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && hasSceneMetadata() == other.hasSceneMetadata()
                && Objects.equals(sceneMetadata(), other.sceneMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSceneRequest").add("WorkspaceId", workspaceId()).add("SceneId", sceneId())
                .add("ContentLocation", contentLocation()).add("Description", description())
                .add("Capabilities", hasCapabilities() ? capabilities() : null).add("Tags", hasTags() ? tags() : null)
                .add("SceneMetadata", hasSceneMetadata() ? sceneMetadata() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "workspaceId":
            return Optional.ofNullable(clazz.cast(workspaceId()));
        case "sceneId":
            return Optional.ofNullable(clazz.cast(sceneId()));
        case "contentLocation":
            return Optional.ofNullable(clazz.cast(contentLocation()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "capabilities":
            return Optional.ofNullable(clazz.cast(capabilities()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "sceneMetadata":
            return Optional.ofNullable(clazz.cast(sceneMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSceneRequest, T> g) {
        return obj -> g.apply((CreateSceneRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTTwinMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateSceneRequest> {
        /**
         * <p>
         * The ID of the workspace that contains the scene.
         * </p>
         * 
         * @param workspaceId
         *        The ID of the workspace that contains the scene.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceId(String workspaceId);

        /**
         * <p>
         * The ID of the scene.
         * </p>
         * 
         * @param sceneId
         *        The ID of the scene.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sceneId(String sceneId);

        /**
         * <p>
         * The relative path that specifies the location of the content definition file.
         * </p>
         * 
         * @param contentLocation
         *        The relative path that specifies the location of the content definition file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentLocation(String contentLocation);

        /**
         * <p>
         * The description for this scene.
         * </p>
         * 
         * @param description
         *        The description for this scene.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A list of capabilities that the scene uses to render itself.
         * </p>
         * 
         * @param capabilities
         *        A list of capabilities that the scene uses to render itself.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(Collection<String> capabilities);

        /**
         * <p>
         * A list of capabilities that the scene uses to render itself.
         * </p>
         * 
         * @param capabilities
         *        A list of capabilities that the scene uses to render itself.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(String... capabilities);

        /**
         * <p>
         * Metadata that you can use to manage the scene.
         * </p>
         * 
         * @param tags
         *        Metadata that you can use to manage the scene.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The request metadata.
         * </p>
         * 
         * @param sceneMetadata
         *        The request metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sceneMetadata(Map<String, String> sceneMetadata);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTTwinMakerRequest.BuilderImpl implements Builder {
        private String workspaceId;

        private String sceneId;

        private String contentLocation;

        private String description;

        private List<String> capabilities = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> sceneMetadata = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSceneRequest model) {
            super(model);
            workspaceId(model.workspaceId);
            sceneId(model.sceneId);
            contentLocation(model.contentLocation);
            description(model.description);
            capabilities(model.capabilities);
            tags(model.tags);
            sceneMetadata(model.sceneMetadata);
        }

        public final String getWorkspaceId() {
            return workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public final String getSceneId() {
            return sceneId;
        }

        public final void setSceneId(String sceneId) {
            this.sceneId = sceneId;
        }

        @Override
        public final Builder sceneId(String sceneId) {
            this.sceneId = sceneId;
            return this;
        }

        public final String getContentLocation() {
            return contentLocation;
        }

        public final void setContentLocation(String contentLocation) {
            this.contentLocation = contentLocation;
        }

        @Override
        public final Builder contentLocation(String contentLocation) {
            this.contentLocation = contentLocation;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getCapabilities() {
            if (capabilities instanceof SdkAutoConstructList) {
                return null;
            }
            return capabilities;
        }

        public final void setCapabilities(Collection<String> capabilities) {
            this.capabilities = SceneCapabilitiesCopier.copy(capabilities);
        }

        @Override
        public final Builder capabilities(Collection<String> capabilities) {
            this.capabilities = SceneCapabilitiesCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(String... capabilities) {
            capabilities(Arrays.asList(capabilities));
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Map<String, String> getSceneMetadata() {
            if (sceneMetadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return sceneMetadata;
        }

        public final void setSceneMetadata(Map<String, String> sceneMetadata) {
            this.sceneMetadata = SceneMetadataMapCopier.copy(sceneMetadata);
        }

        @Override
        public final Builder sceneMetadata(Map<String, String> sceneMetadata) {
            this.sceneMetadata = SceneMetadataMapCopier.copy(sceneMetadata);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSceneRequest build() {
            return new CreateSceneRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
