/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A value that associates a component and an entity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RelationshipValue implements SdkPojo, Serializable,
        ToCopyableBuilder<RelationshipValue.Builder, RelationshipValue> {
    private static final SdkField<String> TARGET_ENTITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetEntityId").getter(getter(RelationshipValue::targetEntityId))
            .setter(setter(Builder::targetEntityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetEntityId").build()).build();

    private static final SdkField<String> TARGET_COMPONENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetComponentName").getter(getter(RelationshipValue::targetComponentName))
            .setter(setter(Builder::targetComponentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetComponentName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_ENTITY_ID_FIELD,
            TARGET_COMPONENT_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String targetEntityId;

    private final String targetComponentName;

    private RelationshipValue(BuilderImpl builder) {
        this.targetEntityId = builder.targetEntityId;
        this.targetComponentName = builder.targetComponentName;
    }

    /**
     * <p>
     * The ID of the target entity associated with this relationship value.
     * </p>
     * 
     * @return The ID of the target entity associated with this relationship value.
     */
    public final String targetEntityId() {
        return targetEntityId;
    }

    /**
     * <p>
     * The name of the target component associated with the relationship value.
     * </p>
     * 
     * @return The name of the target component associated with the relationship value.
     */
    public final String targetComponentName() {
        return targetComponentName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetEntityId());
        hashCode = 31 * hashCode + Objects.hashCode(targetComponentName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelationshipValue)) {
            return false;
        }
        RelationshipValue other = (RelationshipValue) obj;
        return Objects.equals(targetEntityId(), other.targetEntityId())
                && Objects.equals(targetComponentName(), other.targetComponentName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RelationshipValue").add("TargetEntityId", targetEntityId())
                .add("TargetComponentName", targetComponentName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "targetEntityId":
            return Optional.ofNullable(clazz.cast(targetEntityId()));
        case "targetComponentName":
            return Optional.ofNullable(clazz.cast(targetComponentName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RelationshipValue, T> g) {
        return obj -> g.apply((RelationshipValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RelationshipValue> {
        /**
         * <p>
         * The ID of the target entity associated with this relationship value.
         * </p>
         * 
         * @param targetEntityId
         *        The ID of the target entity associated with this relationship value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetEntityId(String targetEntityId);

        /**
         * <p>
         * The name of the target component associated with the relationship value.
         * </p>
         * 
         * @param targetComponentName
         *        The name of the target component associated with the relationship value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetComponentName(String targetComponentName);
    }

    static final class BuilderImpl implements Builder {
        private String targetEntityId;

        private String targetComponentName;

        private BuilderImpl() {
        }

        private BuilderImpl(RelationshipValue model) {
            targetEntityId(model.targetEntityId);
            targetComponentName(model.targetComponentName);
        }

        public final String getTargetEntityId() {
            return targetEntityId;
        }

        public final void setTargetEntityId(String targetEntityId) {
            this.targetEntityId = targetEntityId;
        }

        @Override
        public final Builder targetEntityId(String targetEntityId) {
            this.targetEntityId = targetEntityId;
            return this;
        }

        public final String getTargetComponentName() {
            return targetComponentName;
        }

        public final void setTargetComponentName(String targetComponentName) {
            this.targetComponentName = targetComponentName;
        }

        @Override
        public final Builder targetComponentName(String targetComponentName) {
            this.targetComponentName = targetComponentName;
            return this;
        }

        @Override
        public RelationshipValue build() {
            return new RelationshipValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
