/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iottwinmaker.model.DataValueListCopier;
import software.amazon.awssdk.services.iottwinmaker.model.DataValueMapCopier;
import software.amazon.awssdk.services.iottwinmaker.model.RelationshipValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataValue> {
    private static final SdkField<Boolean> BOOLEAN_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("booleanValue").getter(DataValue.getter(DataValue::booleanValue)).setter(DataValue.setter(Builder::booleanValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("booleanValue").build()}).build();
    private static final SdkField<Double> DOUBLE_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("doubleValue").getter(DataValue.getter(DataValue::doubleValue)).setter(DataValue.setter(Builder::doubleValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("doubleValue").build()}).build();
    private static final SdkField<Integer> INTEGER_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("integerValue").getter(DataValue.getter(DataValue::integerValue)).setter(DataValue.setter(Builder::integerValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integerValue").build()}).build();
    private static final SdkField<Long> LONG_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("longValue").getter(DataValue.getter(DataValue::longValue)).setter(DataValue.setter(Builder::longValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("longValue").build()}).build();
    private static final SdkField<String> STRING_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stringValue").getter(DataValue.getter(DataValue::stringValue)).setter(DataValue.setter(Builder::stringValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stringValue").build()}).build();
    private static final SdkField<List<DataValue>> LIST_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("listValue").getter(DataValue.getter(DataValue::listValue)).setter(DataValue.setter(Builder::listValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listValue").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, DataValue>> MAP_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("mapValue").getter(DataValue.getter(DataValue::mapValue)).setter(DataValue.setter(Builder::mapValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mapValue").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<RelationshipValue> RELATIONSHIP_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("relationshipValue").getter(DataValue.getter(DataValue::relationshipValue)).setter(DataValue.setter(Builder::relationshipValue)).constructor(RelationshipValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationshipValue").build()}).build();
    private static final SdkField<String> EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("expression").getter(DataValue.getter(DataValue::expression)).setter(DataValue.setter(Builder::expression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expression").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOOLEAN_VALUE_FIELD, DOUBLE_VALUE_FIELD, INTEGER_VALUE_FIELD, LONG_VALUE_FIELD, STRING_VALUE_FIELD, LIST_VALUE_FIELD, MAP_VALUE_FIELD, RELATIONSHIP_VALUE_FIELD, EXPRESSION_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean booleanValue;
    private final Double doubleValue;
    private final Integer integerValue;
    private final Long longValue;
    private final String stringValue;
    private final List<DataValue> listValue;
    private final Map<String, DataValue> mapValue;
    private final RelationshipValue relationshipValue;
    private final String expression;

    private DataValue(BuilderImpl builder) {
        this.booleanValue = builder.booleanValue;
        this.doubleValue = builder.doubleValue;
        this.integerValue = builder.integerValue;
        this.longValue = builder.longValue;
        this.stringValue = builder.stringValue;
        this.listValue = builder.listValue;
        this.mapValue = builder.mapValue;
        this.relationshipValue = builder.relationshipValue;
        this.expression = builder.expression;
    }

    public final Boolean booleanValue() {
        return this.booleanValue;
    }

    public final Double doubleValue() {
        return this.doubleValue;
    }

    public final Integer integerValue() {
        return this.integerValue;
    }

    public final Long longValue() {
        return this.longValue;
    }

    public final String stringValue() {
        return this.stringValue;
    }

    public final boolean hasListValue() {
        return this.listValue != null && !(this.listValue instanceof SdkAutoConstructList);
    }

    public final List<DataValue> listValue() {
        return this.listValue;
    }

    public final boolean hasMapValue() {
        return this.mapValue != null && !(this.mapValue instanceof SdkAutoConstructMap);
    }

    public final Map<String, DataValue> mapValue() {
        return this.mapValue;
    }

    public final RelationshipValue relationshipValue() {
        return this.relationshipValue;
    }

    public final String expression() {
        return this.expression;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.booleanValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.doubleValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.integerValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.longValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.stringValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasListValue() ? this.listValue() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMapValue() ? this.mapValue() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.relationshipValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.expression());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataValue)) {
            return false;
        }
        DataValue other = (DataValue)obj;
        return Objects.equals(this.booleanValue(), other.booleanValue()) && Objects.equals(this.doubleValue(), other.doubleValue()) && Objects.equals(this.integerValue(), other.integerValue()) && Objects.equals(this.longValue(), other.longValue()) && Objects.equals(this.stringValue(), other.stringValue()) && this.hasListValue() == other.hasListValue() && Objects.equals(this.listValue(), other.listValue()) && this.hasMapValue() == other.hasMapValue() && Objects.equals(this.mapValue(), other.mapValue()) && Objects.equals(this.relationshipValue(), other.relationshipValue()) && Objects.equals(this.expression(), other.expression());
    }

    public final String toString() {
        return ToString.builder((String)"DataValue").add("BooleanValue", (Object)this.booleanValue()).add("DoubleValue", (Object)this.doubleValue()).add("IntegerValue", (Object)this.integerValue()).add("LongValue", (Object)this.longValue()).add("StringValue", (Object)this.stringValue()).add("ListValue", this.hasListValue() ? this.listValue() : null).add("MapValue", this.hasMapValue() ? this.mapValue() : null).add("RelationshipValue", (Object)this.relationshipValue()).add("Expression", (Object)this.expression()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "booleanValue": {
                return Optional.ofNullable(clazz.cast(this.booleanValue()));
            }
            case "doubleValue": {
                return Optional.ofNullable(clazz.cast(this.doubleValue()));
            }
            case "integerValue": {
                return Optional.ofNullable(clazz.cast(this.integerValue()));
            }
            case "longValue": {
                return Optional.ofNullable(clazz.cast(this.longValue()));
            }
            case "stringValue": {
                return Optional.ofNullable(clazz.cast(this.stringValue()));
            }
            case "listValue": {
                return Optional.ofNullable(clazz.cast(this.listValue()));
            }
            case "mapValue": {
                return Optional.ofNullable(clazz.cast(this.mapValue()));
            }
            case "relationshipValue": {
                return Optional.ofNullable(clazz.cast(this.relationshipValue()));
            }
            case "expression": {
                return Optional.ofNullable(clazz.cast(this.expression()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataValue, T> g) {
        return obj -> g.apply((DataValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean booleanValue;
        private Double doubleValue;
        private Integer integerValue;
        private Long longValue;
        private String stringValue;
        private List<DataValue> listValue = DefaultSdkAutoConstructList.getInstance();
        private Map<String, DataValue> mapValue = DefaultSdkAutoConstructMap.getInstance();
        private RelationshipValue relationshipValue;
        private String expression;

        private BuilderImpl() {
        }

        private BuilderImpl(DataValue model) {
            this.booleanValue(model.booleanValue);
            this.doubleValue(model.doubleValue);
            this.integerValue(model.integerValue);
            this.longValue(model.longValue);
            this.stringValue(model.stringValue);
            this.listValue(model.listValue);
            this.mapValue(model.mapValue);
            this.relationshipValue(model.relationshipValue);
            this.expression(model.expression);
        }

        public final Boolean getBooleanValue() {
            return this.booleanValue;
        }

        public final void setBooleanValue(Boolean booleanValue) {
            this.booleanValue = booleanValue;
        }

        @Override
        public final Builder booleanValue(Boolean booleanValue) {
            this.booleanValue = booleanValue;
            return this;
        }

        public final Double getDoubleValue() {
            return this.doubleValue;
        }

        public final void setDoubleValue(Double doubleValue) {
            this.doubleValue = doubleValue;
        }

        @Override
        public final Builder doubleValue(Double doubleValue) {
            this.doubleValue = doubleValue;
            return this;
        }

        public final Integer getIntegerValue() {
            return this.integerValue;
        }

        public final void setIntegerValue(Integer integerValue) {
            this.integerValue = integerValue;
        }

        @Override
        public final Builder integerValue(Integer integerValue) {
            this.integerValue = integerValue;
            return this;
        }

        public final Long getLongValue() {
            return this.longValue;
        }

        public final void setLongValue(Long longValue) {
            this.longValue = longValue;
        }

        @Override
        public final Builder longValue(Long longValue) {
            this.longValue = longValue;
            return this;
        }

        public final String getStringValue() {
            return this.stringValue;
        }

        public final void setStringValue(String stringValue) {
            this.stringValue = stringValue;
        }

        @Override
        public final Builder stringValue(String stringValue) {
            this.stringValue = stringValue;
            return this;
        }

        public final List<Builder> getListValue() {
            List<Builder> result = DataValueListCopier.copyToBuilder(this.listValue);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setListValue(Collection<BuilderImpl> listValue) {
            this.listValue = DataValueListCopier.copyFromBuilder(listValue);
        }

        @Override
        public final Builder listValue(Collection<DataValue> listValue) {
            this.listValue = DataValueListCopier.copy(listValue);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listValue(DataValue ... listValue) {
            this.listValue(Arrays.asList(listValue));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder listValue(Consumer<Builder> ... listValue) {
            this.listValue(Stream.of(listValue).map(c -> (DataValue)((Builder)DataValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, Builder> getMapValue() {
            Map<String, Builder> result = DataValueMapCopier.copyToBuilder(this.mapValue);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setMapValue(Map<String, BuilderImpl> mapValue) {
            this.mapValue = DataValueMapCopier.copyFromBuilder(mapValue);
        }

        @Override
        public final Builder mapValue(Map<String, DataValue> mapValue) {
            this.mapValue = DataValueMapCopier.copy(mapValue);
            return this;
        }

        public final RelationshipValue.Builder getRelationshipValue() {
            return this.relationshipValue != null ? this.relationshipValue.toBuilder() : null;
        }

        public final void setRelationshipValue(RelationshipValue.BuilderImpl relationshipValue) {
            this.relationshipValue = relationshipValue != null ? relationshipValue.build() : null;
        }

        @Override
        public final Builder relationshipValue(RelationshipValue relationshipValue) {
            this.relationshipValue = relationshipValue;
            return this;
        }

        public final String getExpression() {
            return this.expression;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        @Override
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public DataValue build() {
            return new DataValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataValue> {
        public Builder booleanValue(Boolean var1);

        public Builder doubleValue(Double var1);

        public Builder integerValue(Integer var1);

        public Builder longValue(Long var1);

        public Builder stringValue(String var1);

        public Builder listValue(Collection<DataValue> var1);

        public Builder listValue(DataValue ... var1);

        public Builder listValue(Consumer<Builder> ... var1);

        public Builder mapValue(Map<String, DataValue> var1);

        public Builder relationshipValue(RelationshipValue var1);

        default public Builder relationshipValue(Consumer<RelationshipValue.Builder> relationshipValue) {
            return this.relationshipValue((RelationshipValue)((RelationshipValue.Builder)RelationshipValue.builder().applyMutation(relationshipValue)).build());
        }

        public Builder expression(String var1);
    }
}

