/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iottwinmaker.IoTTwinMakerClient;
import software.amazon.awssdk.services.iottwinmaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.iottwinmaker.model.ListSyncJobsRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ListSyncJobsResponse;

public class ListSyncJobsIterable
implements SdkIterable<ListSyncJobsResponse> {
    private final IoTTwinMakerClient client;
    private final ListSyncJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSyncJobsIterable(IoTTwinMakerClient client, ListSyncJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSyncJobsResponseFetcher();
    }

    public Iterator<ListSyncJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListSyncJobsResponseFetcher
    implements SyncPageFetcher<ListSyncJobsResponse> {
        private ListSyncJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListSyncJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSyncJobsResponse nextPage(ListSyncJobsResponse previousPage) {
            if (previousPage == null) {
                return ListSyncJobsIterable.this.client.listSyncJobs(ListSyncJobsIterable.this.firstRequest);
            }
            return ListSyncJobsIterable.this.client.listSyncJobs((ListSyncJobsRequest)((Object)ListSyncJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

