/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotthingsgraph.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SystemInstanceDeploymentStatus {
    NOT_DEPLOYED("NOT_DEPLOYED"),
    BOOTSTRAP("BOOTSTRAP"),
    DEPLOY_IN_PROGRESS("DEPLOY_IN_PROGRESS"),
    DEPLOYED_IN_TARGET("DEPLOYED_IN_TARGET"),
    UNDEPLOY_IN_PROGRESS("UNDEPLOY_IN_PROGRESS"),
    FAILED("FAILED"),
    PENDING_DELETE("PENDING_DELETE"),
    DELETED_IN_TARGET("DELETED_IN_TARGET"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SystemInstanceDeploymentStatus> VALUE_MAP;
    private final String value;

    private SystemInstanceDeploymentStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SystemInstanceDeploymentStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SystemInstanceDeploymentStatus> knownValues() {
        EnumSet<SystemInstanceDeploymentStatus> knownValues = EnumSet.allOf(SystemInstanceDeploymentStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SystemInstanceDeploymentStatus.class, SystemInstanceDeploymentStatus::toString);
    }
}

