/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotthingsgraph;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.iotthingsgraph.DefaultIoTThingsGraphBaseClientBuilder;
import software.amazon.awssdk.services.iotthingsgraph.DefaultIoTThingsGraphClient;
import software.amazon.awssdk.services.iotthingsgraph.IoTThingsGraphClient;
import software.amazon.awssdk.services.iotthingsgraph.IoTThingsGraphClientBuilder;
import software.amazon.awssdk.services.iotthingsgraph.IoTThingsGraphServiceClientConfiguration;
import software.amazon.awssdk.services.iotthingsgraph.endpoints.IoTThingsGraphEndpointProvider;

@SdkInternalApi
final class DefaultIoTThingsGraphClientBuilder
extends DefaultIoTThingsGraphBaseClientBuilder<IoTThingsGraphClientBuilder, IoTThingsGraphClient>
implements IoTThingsGraphClientBuilder {
    DefaultIoTThingsGraphClientBuilder() {
    }

    @Override
    public DefaultIoTThingsGraphClientBuilder endpointProvider(IoTThingsGraphEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final IoTThingsGraphClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultIoTThingsGraphClientBuilder.validateClientOptions(clientConfiguration);
        IoTThingsGraphServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultIoTThingsGraphClient client = new DefaultIoTThingsGraphClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private IoTThingsGraphServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return IoTThingsGraphServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

