/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotsitewise.IoTSiteWiseAsyncClient;
import software.amazon.awssdk.services.iotsitewise.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotsitewise.model.GetInterpolatedAssetPropertyValuesRequest;
import software.amazon.awssdk.services.iotsitewise.model.GetInterpolatedAssetPropertyValuesResponse;
import software.amazon.awssdk.services.iotsitewise.model.InterpolatedAssetPropertyValue;

public class GetInterpolatedAssetPropertyValuesPublisher
implements SdkPublisher<GetInterpolatedAssetPropertyValuesResponse> {
    private final IoTSiteWiseAsyncClient client;
    private final GetInterpolatedAssetPropertyValuesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetInterpolatedAssetPropertyValuesPublisher(IoTSiteWiseAsyncClient client, GetInterpolatedAssetPropertyValuesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetInterpolatedAssetPropertyValuesPublisher(IoTSiteWiseAsyncClient client, GetInterpolatedAssetPropertyValuesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetInterpolatedAssetPropertyValuesResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetInterpolatedAssetPropertyValuesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<InterpolatedAssetPropertyValue> interpolatedAssetPropertyValues() {
        Function<GetInterpolatedAssetPropertyValuesResponse, Iterator> getIterator = response -> {
            if (response != null && response.interpolatedAssetPropertyValues() != null) {
                return response.interpolatedAssetPropertyValues().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetInterpolatedAssetPropertyValuesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetInterpolatedAssetPropertyValuesResponseFetcher
    implements AsyncPageFetcher<GetInterpolatedAssetPropertyValuesResponse> {
        private GetInterpolatedAssetPropertyValuesResponseFetcher() {
        }

        public boolean hasNextPage(GetInterpolatedAssetPropertyValuesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetInterpolatedAssetPropertyValuesResponse> nextPage(GetInterpolatedAssetPropertyValuesResponse previousPage) {
            if (previousPage == null) {
                return GetInterpolatedAssetPropertyValuesPublisher.this.client.getInterpolatedAssetPropertyValues(GetInterpolatedAssetPropertyValuesPublisher.this.firstRequest);
            }
            return GetInterpolatedAssetPropertyValuesPublisher.this.client.getInterpolatedAssetPropertyValues((GetInterpolatedAssetPropertyValuesRequest)((Object)GetInterpolatedAssetPropertyValuesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

