/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotsitewise.IoTSiteWiseClient;
import software.amazon.awssdk.services.iotsitewise.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueRequest;
import software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueResponse;

public class BatchGetAssetPropertyValueIterable
implements SdkIterable<BatchGetAssetPropertyValueResponse> {
    private final IoTSiteWiseClient client;
    private final BatchGetAssetPropertyValueRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public BatchGetAssetPropertyValueIterable(IoTSiteWiseClient client, BatchGetAssetPropertyValueRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new BatchGetAssetPropertyValueResponseFetcher();
    }

    public Iterator<BatchGetAssetPropertyValueResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class BatchGetAssetPropertyValueResponseFetcher
    implements SyncPageFetcher<BatchGetAssetPropertyValueResponse> {
        private BatchGetAssetPropertyValueResponseFetcher() {
        }

        public boolean hasNextPage(BatchGetAssetPropertyValueResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public BatchGetAssetPropertyValueResponse nextPage(BatchGetAssetPropertyValueResponse previousPage) {
            if (previousPage == null) {
                return BatchGetAssetPropertyValueIterable.this.client.batchGetAssetPropertyValue(BatchGetAssetPropertyValueIterable.this.firstRequest);
            }
            return BatchGetAssetPropertyValueIterable.this.client.batchGetAssetPropertyValue((BatchGetAssetPropertyValueRequest)((Object)BatchGetAssetPropertyValueIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

