/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetAssetPropertyAggregatesRequest extends IoTSiteWiseRequest implements
        ToCopyableBuilder<BatchGetAssetPropertyAggregatesRequest.Builder, BatchGetAssetPropertyAggregatesRequest> {
    private static final SdkField<List<BatchGetAssetPropertyAggregatesEntry>> ENTRIES_FIELD = SdkField
            .<List<BatchGetAssetPropertyAggregatesEntry>> builder(MarshallingType.LIST)
            .memberName("entries")
            .getter(getter(BatchGetAssetPropertyAggregatesRequest::entries))
            .setter(setter(Builder::entries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchGetAssetPropertyAggregatesEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchGetAssetPropertyAggregatesEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(BatchGetAssetPropertyAggregatesRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(BatchGetAssetPropertyAggregatesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTRIES_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final List<BatchGetAssetPropertyAggregatesEntry> entries;

    private final String nextToken;

    private final Integer maxResults;

    private BatchGetAssetPropertyAggregatesRequest(BuilderImpl builder) {
        super(builder);
        this.entries = builder.entries;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * For responses, this returns true if the service returned a value for the Entries property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEntries() {
        return entries != null && !(entries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of asset property aggregate entries for the batch get request. You can specify up to 16 entries per
     * request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEntries} method.
     * </p>
     * 
     * @return The list of asset property aggregate entries for the batch get request. You can specify up to 16 entries
     *         per request.
     */
    public final List<BatchGetAssetPropertyAggregatesEntry> entries() {
        return entries;
    }

    /**
     * <p>
     * The token to be used for the next set of paginated results.
     * </p>
     * 
     * @return The token to be used for the next set of paginated results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return for each paginated request. A result set is returned in the two cases,
     * whichever occurs first.
     * </p>
     * <ul>
     * <li>
     * <p>
     * The size of the result set is equal to 1 MB.
     * </p>
     * </li>
     * <li>
     * <p>
     * The number of data points in the result set is equal to the value of <code>maxResults</code>. The maximum value
     * of <code>maxResults</code> is 4000.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The maximum number of results to return for each paginated request. A result set is returned in the two
     *         cases, whichever occurs first.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The size of the result set is equal to 1 MB.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The number of data points in the result set is equal to the value of <code>maxResults</code>. The maximum
     *         value of <code>maxResults</code> is 4000.
     *         </p>
     *         </li>
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEntries() ? entries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetAssetPropertyAggregatesRequest)) {
            return false;
        }
        BatchGetAssetPropertyAggregatesRequest other = (BatchGetAssetPropertyAggregatesRequest) obj;
        return hasEntries() == other.hasEntries() && Objects.equals(entries(), other.entries())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetAssetPropertyAggregatesRequest").add("Entries", hasEntries() ? entries() : null)
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "entries":
            return Optional.ofNullable(clazz.cast(entries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetAssetPropertyAggregatesRequest, T> g) {
        return obj -> g.apply((BatchGetAssetPropertyAggregatesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSiteWiseRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchGetAssetPropertyAggregatesRequest> {
        /**
         * <p>
         * The list of asset property aggregate entries for the batch get request. You can specify up to 16 entries per
         * request.
         * </p>
         * 
         * @param entries
         *        The list of asset property aggregate entries for the batch get request. You can specify up to 16
         *        entries per request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entries(Collection<BatchGetAssetPropertyAggregatesEntry> entries);

        /**
         * <p>
         * The list of asset property aggregate entries for the batch get request. You can specify up to 16 entries per
         * request.
         * </p>
         * 
         * @param entries
         *        The list of asset property aggregate entries for the batch get request. You can specify up to 16
         *        entries per request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entries(BatchGetAssetPropertyAggregatesEntry... entries);

        /**
         * <p>
         * The list of asset property aggregate entries for the batch get request. You can specify up to 16 entries per
         * request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesEntry.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesEntry.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #entries(List<BatchGetAssetPropertyAggregatesEntry>)}.
         * 
         * @param entries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entries(java.util.Collection<BatchGetAssetPropertyAggregatesEntry>)
         */
        Builder entries(Consumer<BatchGetAssetPropertyAggregatesEntry.Builder>... entries);

        /**
         * <p>
         * The token to be used for the next set of paginated results.
         * </p>
         * 
         * @param nextToken
         *        The token to be used for the next set of paginated results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return for each paginated request. A result set is returned in the two
         * cases, whichever occurs first.
         * </p>
         * <ul>
         * <li>
         * <p>
         * The size of the result set is equal to 1 MB.
         * </p>
         * </li>
         * <li>
         * <p>
         * The number of data points in the result set is equal to the value of <code>maxResults</code>. The maximum
         * value of <code>maxResults</code> is 4000.
         * </p>
         * </li>
         * </ul>
         * 
         * @param maxResults
         *        The maximum number of results to return for each paginated request. A result set is returned in the
         *        two cases, whichever occurs first.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The size of the result set is equal to 1 MB.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The number of data points in the result set is equal to the value of <code>maxResults</code>. The
         *        maximum value of <code>maxResults</code> is 4000.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTSiteWiseRequest.BuilderImpl implements Builder {
        private List<BatchGetAssetPropertyAggregatesEntry> entries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetAssetPropertyAggregatesRequest model) {
            super(model);
            entries(model.entries);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final List<BatchGetAssetPropertyAggregatesEntry.Builder> getEntries() {
            List<BatchGetAssetPropertyAggregatesEntry.Builder> result = BatchGetAssetPropertyAggregatesEntriesCopier
                    .copyToBuilder(this.entries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntries(Collection<BatchGetAssetPropertyAggregatesEntry.BuilderImpl> entries) {
            this.entries = BatchGetAssetPropertyAggregatesEntriesCopier.copyFromBuilder(entries);
        }

        @Override
        public final Builder entries(Collection<BatchGetAssetPropertyAggregatesEntry> entries) {
            this.entries = BatchGetAssetPropertyAggregatesEntriesCopier.copy(entries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(BatchGetAssetPropertyAggregatesEntry... entries) {
            entries(Arrays.asList(entries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(Consumer<BatchGetAssetPropertyAggregatesEntry.Builder>... entries) {
            entries(Stream.of(entries).map(c -> BatchGetAssetPropertyAggregatesEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetAssetPropertyAggregatesRequest build() {
            return new BatchGetAssetPropertyAggregatesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
