/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsecuretunneling;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.iotsecuretunneling.DefaultIoTSecureTunnelingAsyncClient;
import software.amazon.awssdk.services.iotsecuretunneling.DefaultIoTSecureTunnelingBaseClientBuilder;
import software.amazon.awssdk.services.iotsecuretunneling.IoTSecureTunnelingAsyncClient;
import software.amazon.awssdk.services.iotsecuretunneling.IoTSecureTunnelingAsyncClientBuilder;
import software.amazon.awssdk.services.iotsecuretunneling.IoTSecureTunnelingServiceClientConfiguration;
import software.amazon.awssdk.services.iotsecuretunneling.endpoints.IoTSecureTunnelingEndpointProvider;

@SdkInternalApi
final class DefaultIoTSecureTunnelingAsyncClientBuilder
extends DefaultIoTSecureTunnelingBaseClientBuilder<IoTSecureTunnelingAsyncClientBuilder, IoTSecureTunnelingAsyncClient>
implements IoTSecureTunnelingAsyncClientBuilder {
    DefaultIoTSecureTunnelingAsyncClientBuilder() {
    }

    @Override
    public DefaultIoTSecureTunnelingAsyncClientBuilder endpointProvider(IoTSecureTunnelingEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final IoTSecureTunnelingAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultIoTSecureTunnelingAsyncClientBuilder.validateClientOptions(clientConfiguration);
        IoTSecureTunnelingServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultIoTSecureTunnelingAsyncClient client = new DefaultIoTSecureTunnelingAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private IoTSecureTunnelingServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return IoTSecureTunnelingServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

